package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Maps;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.ElemeAbstractService;
import com.ptteng.onway.platform.service.waimai.ElemeClient;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import eleme.openapi.sdk.api.entity.shop.OShop;
import eleme.openapi.sdk.api.enumeration.shop.OShopProperty;
import eleme.openapi.sdk.api.service.ProductService;
import eleme.openapi.sdk.api.service.ShopService;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Map;

/**
 * Author wanglei
 * Created on 18-1-9
 */
public class ElemeStoreServiceImpl extends ElemeAbstractService implements WaimaiStoreService {

    private static Logger logger = Logger.getLogger(ElemeStoreServiceImpl.class);

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        //检查门店是否在百度平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.ELEME)) {
            return;
        }

        ElemeClient elemeClient = getElemeClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (elemeClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.ELEME);

        if (storeMapping == null) {
            return;
        }

        ShopService restaurantService = elemeClient.getShopService();

        try {

            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()));

            if (restaurant != null) {
                ProductService productService = elemeClient.getProductService();
                Map<OShopProperty, Object> shopMap = buildRestaurant(storeId, storeMapping.getTargetId(), productService, waimaiStoreDTO);
                restaurantService.updateShop(Long.valueOf(storeMapping.getMappingId()), shopMap);
            }

        } catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private Map<OShopProperty, Object> buildRestaurant(Long storeId, String targetId, ProductService productService, WaimaiStoreDTO waimaiStoreDTO) {

        //饿了么用image_hash
        String imageHash = "";
        try {
            imageHash = productService.uploadImageWithRemoteUrl(waimaiStoreDTO.getShopLogo() + WaimaiConstants.ImgStyle.ELEME_IMG_STYLE);
        } catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error(e.getMessage(), e);
        }

        Map<OShopProperty, Object> restaurant = Maps.newHashMap();
        restaurant.put(OShopProperty.name, waimaiStoreDTO.getName());
        restaurant.put(OShopProperty.logoImageHash, imageHash);
        //是否接受预定
        restaurant.put(OShopProperty.isBookable, waimaiStoreDTO.getIsBookable());
        //设置营业时间
        restaurant.put(OShopProperty.openTime, waimaiStoreDTO.getOpenTime());
        restaurant.put(OShopProperty.phone, waimaiStoreDTO.getPhone());
        //餐厅公告信息
        restaurant.put(OShopProperty.promotionInfo, waimaiStoreDTO.getPromotionInfo());
        //是否支持开发票
        restaurant.put(OShopProperty.invoice, waimaiStoreDTO.getIsInvoice());
        //最小发票金额
        restaurant.put(OShopProperty.invoiceMinAmount, CommonUtil.fenChangeY(waimaiStoreDTO.getInvoiceMinAmount()));
        //满xx元免配送费 // 小于零既 不免运费
        if (waimaiStoreDTO.getNoAgentFeeTotal() > 0) {
            restaurant.put(OShopProperty.noAgentFeeTotal, CommonUtil.fenChangeY(waimaiStoreDTO.getNoAgentFeeTotal()));
        }
        //订单打包费，对于该店铺的每张订单，如果有店铺订单打包费，则采用该值；如果没有，则根据订单中的菜品来决定打包费。注：设置该值为 -1 表示禁用该值。
        restaurant.put(OShopProperty.packingFee, CommonUtil.fenChangeY(waimaiStoreDTO.getPackingFee()));
        return restaurant;
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        //检查门店是否在百度平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.ELEME)) {
            return;
        }

        ElemeClient elemeClient = getElemeClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (elemeClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.ELEME);

        if (storeMapping == null) {
            return;
        }

        ShopService restaurantService = elemeClient.getShopService();

        try {

            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()));

            if (restaurant != null) {
                Map<OShopProperty, Object> map = Maps.newHashMap();
                map.put(OShopProperty.isOpen, "1");
                restaurantService.updateShop(Long.valueOf(storeMapping.getTargetId()), map);
            }

        } catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        //检查门店是否在百度平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.ELEME)) {
            return;
        }

        ElemeClient elemeClient = getElemeClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (elemeClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.ELEME);

        if (storeMapping == null) {
            return;
        }

        ShopService restaurantService = elemeClient.getShopService();

        try {

            OShop restaurant = restaurantService.getShop(Long.valueOf(storeMapping.getMappingId()));

            if (restaurant != null) {
                Map<OShopProperty, Object> map = Maps.newHashMap();
                map.put(OShopProperty.isOpen, "0");
                restaurantService.updateShop(Long.valueOf(storeMapping.getTargetId()), map);
            }

        } catch (eleme.openapi.sdk.api.exception.ServiceException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        return null;
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {

    }
}
