package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Lists;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.ShopService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.BussinessTime;
import com.jiabangou.bdwmsdk.model.Shop;
import com.jiabangou.bdwmsdk.model.ShopDetail;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * 百度外卖store 同步
 * Created by wanglei on 16/7/22.
 */
public class BaiduStoreServiceImpl extends BaiduAbstractService implements WaimaiStoreService {

    private static Logger logger = Logger.getLogger(BaiduStoreServiceImpl.class);

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        //检查门店是否在百度平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.BAIDU)) {
            return;
        }

        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        ShopService shopService = bdWmClient.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);

        String mappingId;

        if (storeMapping == null) {
            mappingId = String.valueOf(storeId);
        } else {
            mappingId = storeMapping.getMappingId();
        }

        ShopDetail shopDetail = this.getStore(mappingId, shopService);

        try {
            if (shopDetail != null) {
                Shop shop = buildUpdateShop(mappingId, waimaiStoreDTO);
                shopService.update(shop);
            }
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    private ShopDetail getStore(String mappingId, ShopService shopService) {

        try {

            return shopService.getDetail(mappingId);

        } catch (BdWmErrorException bdWmErrorException) {

            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
            return null;

        }
    }

    private Shop buildCreateShop(String mappingId, WaimaiStoreDTO waiMaiDTO) {

        Shop shop = new Shop();
        shop.setShop_id(mappingId);
        shop.setName(waiMaiDTO.getName());
        shop.setShop_logo(waiMaiDTO.getShopLogo() + WaimaiConstants.ImgStyle.BAIDU_IMG_STYLE);
        shop.setPhone(waiMaiDTO.getPhone());
        shop.setService_phone(waiMaiDTO.getServicePhone());
        //准备配送时间数据
        String[] businessTimes = waiMaiDTO.getOpenTime().split(",");
        List<BussinessTime> business_time = Lists.newArrayList();
        if(businessTimes.length != 0){
            for(String businessTimeStr: businessTimes){
                String[] businessTimeStartEnd = businessTimeStr.split("-");
                if(businessTimeStartEnd.length == 2){
                    BussinessTime bussinessTime = new BussinessTime();
                    bussinessTime.setStart(businessTimeStartEnd[0]);
                    bussinessTime.setEnd(businessTimeStartEnd[1]);
                    business_time.add(bussinessTime);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(business_time)) {
            shop.setBusiness_time(business_time);
        }
        //是否支持发票
        shop.setInvoice_support((waiMaiDTO.getIsInvoice()));
        //外卖起送价，单位：分
        shop.setMin_order_price(waiMaiDTO.getMinOrderPrice());
        //餐盒费，单位：分
        shop.setPackage_box_price(waiMaiDTO.getPackageBoxPrice());

        return shop;
    }

    private Shop buildUpdateShop(String mappingId, WaimaiStoreDTO waiMaiDTO) {
        Shop shop = buildCreateShop(mappingId, waiMaiDTO);
        //百度那边设置的字段，这边传空
        shop.setDelivery_region(null);
        shop.setMin_order_price(null);
        shop.setName(null);
        return shop;
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        //检查门店是否在百度平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.BAIDU)) {
            return;
        }

        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        ShopService shopService = bdWmClient.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);

        String mappingId;

        if (storeMapping == null) {
            mappingId = String.valueOf(storeId);
        } else {
            mappingId = storeMapping.getMappingId();
        }

        ShopDetail shopDetail = this.getStore(mappingId, shopService);

        try {
            if (shopDetail != null) {
                shopService.open(mappingId);
            }
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);
        if (storeMapping == null) {
            return;
        }

        ShopService shopService = bdWmClient.getShopService();

        try {
            shopService.offline(storeMapping.getMappingId());
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        return null;
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {

    }
}
