package com.ptteng.onway.platform.service.waimai.store;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;

import java.util.List;

/**
 * Created by wanglei on 16-3-15.
 */
public interface WaimaiStoreService {

    void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException;

    void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException;

    void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException;
}
