package com.ptteng.onway.platform.service.waimai.other.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiOrderMappingDTO;
import com.ptteng.onway.platform.model.WaimaiStoreMappingDTO;
import com.ptteng.onway.platform.service.WaimaiService;
import com.ptteng.onway.platform.service.waimai.other.ConvertUtils;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiLogInfoDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiOrderMappingDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiStoreMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiLogInfo;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;

/**
 * Created by wanglei on 16-3-21.
 */
public class WaimaiServiceImpl implements WaimaiService {

    @Autowired
    private WaimaiLogInfoDao waimaiLogInfoDao;

    @Autowired
    private WaimaiStoreMappingDao waimaiStoreMappingDao;

    @Autowired
    private WaimaiOrderMappingDao waimaiOrderMappingDao;

    @Override
    public void saveWaiMaiLog(String cmd, String method, Boolean isSuccess, String request, String response) throws ServiceException, ServiceDaoException  {
        WaimaiLogInfo log = new WaimaiLogInfo();
        log.setCmd(cmd);
        log.setMethod(method);
        log.setIsSuccess(isSuccess);
        log.setRequest(request);
        log.setResponse(response);
        waimaiLogInfoDao.saveLogInfo(log);
    }

    @Override
    public WaimaiStoreMappingDTO findStoreMappingByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiStoreMapping waimaiStoreMapping = waimaiStoreMappingDao.findOneByMappingIdPlatformType(mappingId, platformType);
        if(Objects.isNull(waimaiStoreMapping)){
            return null;
        }
        return ConvertUtils.convert(waimaiStoreMapping, WaimaiStoreMappingDTO.class);
    }

    @Override
    public WaimaiStoreMappingDTO findStoreMappingByStoreIdPlatformType(Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiStoreMapping waimaiStoreMapping = waimaiStoreMappingDao.findOneByStoreIdPlatformType(storeId, platformType);
        if(Objects.isNull(waimaiStoreMapping)){
            return null;
        }
        return ConvertUtils.convert(waimaiStoreMapping, WaimaiStoreMappingDTO.class);
    }

    @Override
    public WaimaiOrderMappingDTO findOrderMappingByTargetIdPlatformType(String targetId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiOrderMapping waimaiOrderMapping = waimaiOrderMappingDao.findOneByTargetIdPlatformType(targetId, platformType);
        if(Objects.isNull(waimaiOrderMapping)){
            return null;
        }
        return ConvertUtils.convert(waimaiOrderMapping, WaimaiOrderMappingDTO.class);
    }

    @Override
    public void saveOrderMapping(Long mchId, Long storeId, Long orderId, String targetId, String viewId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiOrderMapping orderMapping = new WaimaiOrderMapping();
        orderMapping.setMchId(mchId);
        orderMapping.setStoreId(storeId);
        orderMapping.setOrderId(orderId);
        orderMapping.setTargetId(targetId);
        orderMapping.setViewId(viewId);
        orderMapping.setPlatformType(platformType);
        waimaiOrderMappingDao.saveOrderMapping(orderMapping);
    }
}
