package com.ptteng.onway.platform.service.waimai.other.daos.impls;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.collect.Maps;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiStoreMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by wanglei on 16-3-16.
 */
public class WaimaiStoreMappingDaoImpl extends BaseDaoServiceImpl implements WaimaiStoreMappingDao {

    private static final Log logger = LogFactory.getLog(WaimaiStoreMappingDaoImpl.class);

    @Override
    public WaimaiStoreMapping findOneByMchIdStoreIdPlatformType(Long mchId, Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("mch_id", mchId);
        filterMap.put("store_id", storeId);
        filterMap.put("platform_type", "'" + platformType + "'");
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_store_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiStoreMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiStoreMapping mapping;
        try {
            mapping = (WaimaiStoreMapping) dao.get(WaimaiStoreMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiStoreMapping  findOneByMchIdStoreIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;

    }

    @Override
    public WaimaiStoreMapping findOneByStoreIdPlatformType(Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("store_id", storeId);
        filterMap.put("platform_type", "'" + platformType + "'");
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_store_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiStoreMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiStoreMapping mapping;
        try {
            mapping = (WaimaiStoreMapping) dao.get(WaimaiStoreMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiStoreMapping  findOneByMchIdStoreIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public WaimaiStoreMapping findOneByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("mappingId", mappingId);
        filterMap.put("platformType", platformType);
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_store_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiStoreMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiStoreMapping mapping;
        try {
            mapping = (WaimaiStoreMapping) dao.get(WaimaiStoreMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiStoreMapping findOneByMappingIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public void saveStoreMapping(WaimaiStoreMapping storeMapping) throws ServiceException, ServiceDaoException {
        try {
            dao.save(storeMapping);
        } catch (DaoException e) {
            logger.error("WaimaiStoreMapping saveStoreMapping error : ", e);
            throw new ServiceDaoException(e);
        }

    }
}
