package com.ptteng.onway.platform.service.waimai.other.daos.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.collect.Maps;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiOrderMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by wanglei on 16-3-16.
 */
public class WaimaiOrderMappingDaoImpl extends BaseDaoServiceImpl implements WaimaiOrderMappingDao {

    private static final Log logger = LogFactory.getLog(WaimaiOrderMappingDaoImpl.class);

    @Override
    public WaimaiOrderMapping findOneByMchIdStoreIdOrderIdPlatformType(Long mchId, Long storeId, Long orderId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("mchId", mchId);
        filterMap.put("storeId", storeId);
        filterMap.put("orderId", orderId);
        filterMap.put("platformType", platformType);
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_order_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiOrderMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiOrderMapping mapping;
        try {
            mapping = (WaimaiOrderMapping) dao.get(WaimaiOrderMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiOrderMapping findOneByMchIdStoreIdOrderIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public WaimaiOrderMapping findOneByTargetIdPlatformType(String targetId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("targetId", targetId);
        filterMap.put("platformType", platformType);
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_order_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiOrderMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiOrderMapping mapping;
        try {
            mapping = (WaimaiOrderMapping) dao.get(WaimaiOrderMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiOrderMapping findOneByTargetIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public void saveOrderMapping(WaimaiOrderMapping waimaiOrderMapping) throws ServiceException, ServiceDaoException {
        try {
            dao.save(waimaiOrderMapping);
        } catch (DaoException e) {
            logger.error("WaimaiOrderMapping saveOrderMapping error : ", e);
            throw new ServiceDaoException(e);
        }

    }

    @Override
    public void updateOrderMapping(WaimaiOrderMapping waimaiOrderMapping) throws ServiceException, ServiceDaoException {
        try {
            dao.update(waimaiOrderMapping);
        } catch (DaoException e) {
            logger.error("WaimaiOrderMapping updateOrderMapping error : ", e);
            throw new ServiceDaoException(e);
        }

    }

}
