package com.ptteng.onway.platform.service.waimai.other.daos.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.collect.Maps;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiDishMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishMapping;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by wanglei on 16-3-16.
 */
public class WaimaiDishMappingDaoImpl extends BaseDaoServiceImpl implements WaimaiDishMappingDao {

    private static final Log logger = LogFactory.getLog(WaimaiDishCategoryMappingDaoImpl.class);

    @Override
    public WaimaiDishMapping findOneByMchIdStoreIdDishNormIdPlatformType(Long mchId, Long storeId, Long dishNormId, String platformType) throws ServiceException, ServiceDaoException  {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("mchId", mchId);
        filterMap.put("storeId", storeId);
        filterMap.put("dishNormId", dishNormId);
        filterMap.put("platformType", platformType);
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_dish_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiDishMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiDishMapping mapping;
        try {
            mapping = (WaimaiDishMapping) dao.get(WaimaiDishMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiDishMapping findOneByMchIdStoreIdDishNormIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public void saveDishMapping(WaimaiDishMapping dishMapping) throws ServiceException, ServiceDaoException {
        try {
            this.dao.save(dishMapping);
        } catch (DaoException e) {
            logger.error("WaimaiDishMapping saveDishMapping error : " + dishMapping.toString(), e);
            throw new ServiceDaoException(e);
        }
    }

    @Override
    public void updateDishMapping(WaimaiDishMapping dishMapping) throws ServiceException, ServiceDaoException {
        try {
            this.dao.update(dishMapping);
        } catch (DaoException e) {
            logger.error("WaimaiDishMapping updateDishMapping error : " + dishMapping.toString(), e);
            throw new ServiceDaoException(e);
        }
    }
}
