package com.ptteng.onway.platform.service.waimai.other.daos.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.collect.Maps;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiDishCategoryMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishCategoryMapping;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Created by wanglei on 16-3-16.
 */
public class WaimaiDishCategoryMappingDaoImpl extends BaseDaoServiceImpl implements WaimaiDishCategoryMappingDao {

    private static final Log logger = LogFactory.getLog(WaimaiDishCategoryMappingDaoImpl.class);

    @Override
    public WaimaiDishCategoryMapping findOneByMchIdStoreIdCategoryIdPlatformType(Long mchId, Long storeId,
                                                                                 Long categoryId, String platformType) throws ServiceException, ServiceDaoException {
        Map<String, Object> filterMap = Maps.newHashMap();
        filterMap.put("mchId", mchId);
        filterMap.put("storeId", storeId);
        filterMap.put("categoryId", categoryId);
        filterMap.put("platformType", platformType);
        filterMap.put("@query"," id");
        filterMap.put("@order", "created_at desc ");
        filterMap.put("@table"," waimai_dish_category_mappings ");
        List<Long> idList = getIdsByDynamicCondition(WaimaiDishCategoryMapping.class, filterMap, 0, 1);
        if (CollectionUtils.isEmpty(idList)) {
            return null;
        }
        WaimaiDishCategoryMapping mapping;
        try {
            mapping = (WaimaiDishCategoryMapping) dao.get(WaimaiDishCategoryMapping.class, idList.get(0));
        } catch (DaoException e) {
            logger.error("WaimaiDishCategoryMapping findOneByMchIdStoreIdCategoryIdPlatformType error : " + idList, e);
            throw new ServiceDaoException(e);
        }
        return mapping;
    }

    @Override
    public void saveDishCategoryMapping(WaimaiDishCategoryMapping dishCategoryMapping) throws ServiceException, ServiceDaoException {
        try {
            this.dao.save(dishCategoryMapping);
        } catch (DaoException e) {
            logger.error("WaimaiDishCategoryMapping saveDishCategoryMapping error : " + dishCategoryMapping.toString(), e);
            throw new ServiceDaoException(e);
        }
    }

    @Override
    public void updateDishCategoryMapping(WaimaiDishCategoryMapping dishCategoryMapping) throws ServiceException, ServiceDaoException {
        try {
            this.dao.update(dishCategoryMapping);
        } catch (DaoException e) {
            logger.error("WaimaiDishCategoryMapping updateDishCategoryMapping error : " + dishCategoryMapping.toString(), e);
            throw new ServiceDaoException(e);
        }
    }
}
