package com.ptteng.onway.platform.service.waimai.other.daos;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;

/**
 * Created by wanglei on 16-3-16.
 */
public interface WaimaiStoreMappingDao extends BaseDaoService {

    /**
     * 根据商户id,门店id查找对应对应数据
     *
     * @param mchId 商户id
     * @param storeId 门店id
     * @return 对应关系数据
     */
    WaimaiStoreMapping findOneByMchIdStoreIdPlatformType(Long mchId, Long storeId, String platformType) throws ServiceException, ServiceDaoException;

    WaimaiStoreMapping findOneByStoreIdPlatformType(Long storeId, String platformType) throws ServiceException, ServiceDaoException;

    WaimaiStoreMapping findOneByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException;

    void saveStoreMapping(WaimaiStoreMapping storeMapping) throws ServiceException, ServiceDaoException;

}
