package com.ptteng.onway.platform.service.waimai.other.daos;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishCategoryMapping;

/**
 * Created by wanglei on 16-3-16.
 */
public interface WaimaiDishCategoryMappingDao extends BaseDaoService {

    /**
     * 根据分类名称查找数据
     *
     * @param mchId 商户id
     * @param storeId 门店id
     * @param categoryId 分类id
     * @return 对应关系数据
     */
    WaimaiDishCategoryMapping findOneByMchIdStoreIdCategoryIdPlatformType(Long mchId, Long storeId, Long categoryId, String platformType) throws ServiceException, ServiceDaoException;

    /**
     * 保存菜品分类对应关系
     *
     * @param dishCategoryMapping 菜品分类对应关系对象
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void saveDishCategoryMapping(WaimaiDishCategoryMapping dishCategoryMapping) throws ServiceException, ServiceDaoException;

    /**
     * 更新菜品分类对应关系
     *
     * @param dishCategoryMapping 菜品分类对应关系对象
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void updateDishCategoryMapping(WaimaiDishCategoryMapping dishCategoryMapping) throws ServiceException, ServiceDaoException;
}
