package com.ptteng.onway.platform.service.waimai.other;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by wangziqing on 16/3/11.
 */
public interface WaimaiConstants {

    Integer ZERO = 0;

    String SUCCESS = "success";

    int REMAINING_COUNT_THRESHOLD = 20;

    int INIT_STOCK_COUNT = 300;

    //外卖平台类型
    interface PlatformType {
        //百度外卖
        String BAIDU = "000010";

        //美团外卖
        String MEITUAN = "000001";

        //饿了么
        String ELEME = "000100";
    }

    interface ImgStyle {
        //百度外卖 图片尺寸是750 x 625
        String BAIDU_IMG_STYLE = "@750w_625h_1e_1c_1pr";
        //饿了么外卖 图片尺寸是750 x 720
        String ELEME_IMG_STYLE = "@750w_750h_1e_1c_1pr";
        //美团外卖 图片尺寸是750 x 720
        String MEITUAN_IMG_STYLE = "@750w_625h_1e_1c_1pr";
    }

    interface dishParms {
        String PARMS_BAIDU_DELIVERY_TIME = "baidu_delivery_time";//对应#DishDeliveryTimeDTO
    }

    interface Scene {
        //外卖
        String TAKEOUT = "takeOut";
    }

    interface LogConstants {

        enum OperateTarget {
            STORE("store", "门店"),
            DISH("dish", "菜品"),
            DISH_CATEGORY("category", "菜品分类"),
            ORDER("order", "订单");

            private String code;
            private String name;

            OperateTarget(String code, String name) {
                this.code = code;
                this.name = name;
            }

            public String getCode() {
                return code;
            }

            public void setCode(String code) {
                this.code = code;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public static String getOperateTargetName(String code) {
                for (OperateTarget operateTarget : OperateTarget.values()) {
                    if (StringUtils.equals(operateTarget.getCode(), code)) {
                        return operateTarget.getName();
                    }
                }
                return "";
            }
        }

        enum RequestType {
            UP("up", "上行接口"),
            DOWN("down", "下行接口");

            private String code;
            private String name;

            RequestType(String code, String name) {
                this.code = code;
                this.name = name;
            }

            public String getCode() {
                return code;
            }

            public void setCode(String code) {
                this.code = code;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public static String getOrequestTypeName(String code) {
                for (RequestType requestType : RequestType.values()) {
                    if (StringUtils.equals(requestType.getCode(), code)) {
                        return requestType.getName();
                    }
                }
                return "";
            }
        }
    }

    interface OrderFixStatus {
        String YES = "yes";
        String NO = "no";
    }


}
