/*
 *  Copyright (c) 2015.  meicanyun.com Corporation Limited.
 *  All rights reserved.
 *
 *  This software is the confidential and proprietary information of
 *  meicanyun Company. ("Confidential Information").  You shall not
 *  disclose such Confidential Information and shall use it only in
 *  accordance with the terms of the license agreement you entered into
 *  with meicanyun.com.
 */

package com.ptteng.onway.platform.service.waimai.other;

import com.gemantic.common.exception.ServiceException;
import org.apache.commons.collections.map.HashedMap;

import java.util.*;

/**
 * 转换帮助类
 * Created by freeway on 15/12/4.
 */
public class ConvertUtils {

    public static <T> T convert(Object src, Class<T> destType) throws ServiceException {
        if (src == null) {
            return null;
        }
        T t = null;
        try {
            t = (T) destType.newInstance();
            org.apache.commons.beanutils.BeanUtils.copyProperties(t, src);
        } catch (Exception e) {
            throw new ServiceException("data convert error.", e);
        }
        return t;
    }

    public static void convert(Object src, Object dest) throws ServiceException  {
        try {
            org.apache.commons.beanutils.BeanUtils.copyProperties(dest, src);
        } catch (Exception e) {
            throw new ServiceException("data convert error.", e);
        }
    }

    public static <T> List<T> converts(List list, Class<T> destType) throws ServiceException {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }

        List<T> userDTOs = new ArrayList<T>(list.size());
        for (Object obj : list) {
            userDTOs.add((T) convert(obj, destType));
        }
        return userDTOs;
    }

    public static <K,T> Map<K, T> convertMap(Map<K,?> map, Class<T> destType) throws ServiceException {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<K, T> destMap = new HashedMap(map.size());
        Set<? extends Map.Entry<K, ?>> set = map.entrySet();
        for (Map.Entry<K, ?> entry : set) {
            destMap.put(entry.getKey(), convert(entry.getValue(), destType));
        }
        return destMap;
    }

}
