package com.ptteng.onway.platform.service.waimai.other;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;

/**
 * Created by apple on 15/12/18.
 */
public class CommonUtil {

    public static String fenChangeY(Integer fen){
        float r = fen==null?0.00f:fen/100.00f;
        double y = Math.round(r * 100.00) / 100.00;
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(y);
    }

    public static String fenChangeY(Long fen){
        float r = fen==null?0.00f:fen/100.00f;
        double y = Math.round(r * 100.00) / 100.00;
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(y);
    }

    public static Double fenChangeYDouble(Integer fen){
        float r = fen==null?0.00f:fen/100.00f;
        double y = Math.round(r * 100) / 100.00;

        return y;
    }

    public static String transformToString(double price){

        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(price);
    }

    public static Double transform(double price){
        DecimalFormat df = new DecimalFormat("0.00");
        return Double.valueOf(df.format(price));
    }

    public static int transformToInt(double price){
        return (int)Math.round(price);
    }

    public static long yChangeFen(String y){
        Double x = Double.parseDouble(y);
        return  Math.round(x*100);
    }

    public static int yChangeFenToInt(String y){
        Double x = Double.parseDouble(y);
        return  (int)Math.round(x*100);
    }

    public static long yChangeFenToLong(String y){
        Double x = Double.parseDouble(y);
        return (long)Math.round(x*100);
    }

    public static long yChangeFen(double y){
        return Math.round(y*100);
    }
    public static int yChangeFenToInt(double y){
        return (int)Math.round(y*100);
    }


    /**
     * @description 射线法判断点是否在多边形内部
     * @param {Object} p 待判断的点，格式：{ x: X坐标, y: Y坐标 }
     * @param {Array} poly 多边形顶点，数组成员的格式同 p
     * @return {Boolean} 点 p 和多边形 poly 的几何关系
     */
    public static boolean rayCasting(String lng,String lat,String polys){
        String[] poly = org.apache.commons.lang3.StringUtils.split(polys,";");
        double px = Double.parseDouble(lng);
        double py = Double.parseDouble(lat);
        boolean flag = false;
        for(int i=0,l=poly.length,j=l-1;i<l;j=i,i++){
            String[] s = org.apache.commons.lang3.StringUtils.split(poly[i],",");
            String[] t = org.apache.commons.lang3.StringUtils.split(poly[j],",");
            double sx = Double.parseDouble(s[0]);
            double sy = Double.parseDouble(s[1]);
            double tx = Double.parseDouble(t[0]);
            double ty = Double.parseDouble(t[1]);
            // 点与多边形顶点重合
            if((sx == px && sy == py) || (tx == px && ty == py)) {
                return true;
            }
            // 判断线段两端点是否在射线两侧
            if((sy < py && ty >= py) || (sy >= py && ty < py)) {
                // 线段上与射线 Y 坐标相同的点的 X 坐标
                double x = sx + (py - sy) * (tx - sx) / (ty - sy);

                // 点在多边形的边上
                if(x == px) {
                    return true;
                }

                // 射线穿过多边形的边界
                if(x > px) {
                    flag = !flag;
                }
            }
        }
        // 射线穿过多边形边界的次数为奇数时点在多边形内
        return flag ? true : false;
    }


    /**
     * 全角转半角
     *
     * @param input String.
     * @return 半角字符串
     */
    public static String ToDBC(String input) {
        char c[] = input.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (c[i] == '\u3000') {
                c[i] = ' ';
            } else if (c[i] > '\uFF00' && c[i] < '\uFF5F') {
                c[i] = (char) (c[i] - 65248);

            }
        }
        return new String(c);
    }

    /**
     * @description 射线法判断点是否在多边形内部
     * @param {Object} p 待判断的点，格式：{ x: X坐标, y: Y坐标 }
     * @param {Array} poly 多边形顶点，数组成员的格式同 p
     * @return {Boolean} 点 p 和多边形 poly 的几何关系

    function rayCasting(p, poly) {
    var px = p.x,
    py = p.y,
    flag = false;

    for(var i = 0, l = poly.length, j = l - 1; i < l; j = i, i++) {
    var sx = poly[i].x,
    sy = poly[i].y,
    tx = poly[j].x,
    ty = poly[j].y;

    // 点与多边形顶点重合
    if((sx === px && sy === py) || (tx === px && ty === py)) {
    return true;
    }

    // 判断线段两端点是否在射线两侧
    if((sy < py && ty >= py) || (sy >= py && ty < py)) {
    // 线段上与射线 Y 坐标相同的点的 X 坐标
    var x = sx + (py - sy) * (tx - sx) / (ty - sy)

    // 点在多边形的边上
    if(x === px) {
    return true;
    }

    // 射线穿过多边形的边界
    if(x > px) {
    flag = !flag;
    }
    }
    }

    // 射线穿过多边形边界的次数为奇数时点在多边形内
    return flag ? true : false;
    }
     */

    public static String captureName(String name){
        char[] cs=name.toCharArray();
        cs[0]-=32;
        return String.valueOf(cs);
    }

    public static String lowerName(String name){
        char[] cs=name.toCharArray();
        cs[0]-=32;
        return String.valueOf(cs);
    }

    public static String getColumn(String s){
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for(int i=0;i<chars.length;i++){
            if(Character.isUpperCase(chars[i])){
                sb.append("_");
                chars[i]+=32;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    //List去重
    public static <T> void removeDuplicate(List<T> list) {
        HashSet<T> h = new HashSet<T>(list);
        list.clear();
        list.addAll(h);
        System.out.println(list);
    }
}
