package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Sets;
import com.ptteng.onway.platform.service.WaimaiOrderHandleService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Set;

/**
 * 菜品消费者服务实现
 * Created by freeway on 16/7/22.
 */
public class OrderHandleServiceImpl implements WaimaiOrderHandleService {

    @Autowired
    @Qualifier("meituanOrderService")
    private static WaimaiOrderService meituanOrderService;

    private static final Set<WaimaiOrderService> waimaiOrderServices = Sets.newHashSet();

    static {
        waimaiOrderServices.add(meituanOrderService);
    }

    @Override
    public void confirm(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.confirmOrder(mchId, storeId, orderId);
        }
    }

    @Override
    public void cancel(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.cancelOrder(mchId, storeId, orderId, reasonId, reason);
        }
    }

    @Override
    public void complete(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.completeOrder(mchId, storeId, orderId);
        }
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.agreeRefund(mchId, storeId, orderId);
        }
    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.disagreeRefund(mchId, storeId, orderId, reason);
        }
    }
}
