package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.OrderService;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.apache.log4j.Logger;

import java.util.Objects;

/**
 * Created by wanglei on 16-10-13.
 */
public class MeituanOrderServiceImpl extends MeituanAbstractService implements WaimaiOrderService {

    private static Logger logger = Logger.getLogger(MeituanOrderServiceImpl.class);

    @Override
    public void confirmOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!isMeituanOrder(orderId)) {
            return;
        }

        MtWmClient client = getMtWmClient(mchId);
        if (Objects.isNull(client)) {
            return;
        }

        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (Objects.isNull(storeMapping)) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.MEITUAN);
        if (Objects.isNull(orderMapping)) {
            return;
        }

        try {
            client.getOrderService().confirm(orderMapping.getTargetId());
        } catch (MtWmErrorException e) {
            logger.info("美团外卖确认订单失败，请检查错误日志!");
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void cancelOrder(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是饿了么的订单
        if (!isMeituanOrder(orderId)) {
            return;
        }


        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (client == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.MEITUAN);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = client.getOrderService();

        try {
            orderService.cancel(orderMapping.getTargetId(), cancelReasonCodeTransform(reasonId.intValue()), reason);
        } catch (MtWmErrorException e) {
            logger.error(e.getMessage(), e);
            throw new ServiceException(e);
        }
    }

    private Integer cancelReasonCodeTransform(Integer selfPlatformReasonCode) {
        switch (selfPlatformReasonCode) {
            //不在配送范围内
            case 1:
                return 2010;
            //门店已打烊
            case 2:
                return 2011;
            //美食已售罄
            case 3:
                return selfPlatformReasonCode;
            //菜品价格发生变化
            case 4:
                return selfPlatformReasonCode;
            //用户取消订单
            case 5:
                return 2006;
            //重复订单
            case 6:
                return 2013;
            //门店太忙
            case 7:
                return 2008;
            //联系不上用户
            case 8:
                return 2012;
            //假订单
            case 9:
                return selfPlatformReasonCode;
            default:
                return selfPlatformReasonCode;
        }
    }


    @Override
    public void completeOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!isMeituanOrder(orderId)) {
            return;
        }

        MtWmClient client = getMtWmClient(mchId);
        if (Objects.isNull(client)) {
            return;
        }

        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (Objects.isNull(storeMapping)) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.MEITUAN);
        if (Objects.isNull(orderMapping)) {
            return;
        }

        try {
            client.getOrderService().arrived(orderMapping.getTargetId());
        } catch (MtWmErrorException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是饿了么的订单
        if (!isMeituanOrder(orderId)) {
            return;
        }


        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (client == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.MEITUAN);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = client.getOrderService();

        try {
            orderService.agreeRefund(orderMapping.getTargetId(), "顾客就是上帝确认退款");
        } catch (MtWmErrorException e) {
            logger.error(e.getMessage(), e);
            throw new ServiceException(e);
        }
    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是饿了么的订单
        if (!isMeituanOrder(orderId)) {
            return;
        }


        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (client == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.MEITUAN);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = client.getOrderService();

        try {
            orderService.disagreeRefund(orderMapping.getTargetId(), (reason == null || reason.equals("")) ? "商家拒绝退款" : reason);
        } catch (MtWmErrorException e) {
            logger.error(e.getMessage(), e);
        }
    }
}
