package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.OrderService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.apache.log4j.Logger;

/**
 * Author wanglei
 * Created on 18-1-9
 */
public class BaiduOrderServiceImpl extends BaiduAbstractService implements WaimaiOrderService {

    private static Logger logger = Logger.getLogger(MeituanOrderServiceImpl.class);

    @Override
    public void confirmOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是百度的订单
        if (!isBaiduOrder(orderId)){
            return;
        }

        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.BAIDU);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = bdWmClient.getOrderService();

        //确认百度订单
        try {
            orderService.confirm(orderMapping.getTargetId());
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void cancelOrder(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是百度的订单
        if (!isBaiduOrder(orderId)){
            return;
        }

        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.BAIDU);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = bdWmClient.getOrderService();

        //确认百度订单
        try {
            orderService.cancel(orderMapping.getTargetId(), reasonId.intValue(), reason);
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void completeOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        //确认订单是否存在及是否是百度的订单
        if (!isBaiduOrder(orderId)){
            return;
        }

        BdWmClient bdWmClient = getBdWmClient(mchId);
        // 如果为空表示不支持同步到百度外卖
        if (bdWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.BAIDU);
        if (storeMapping == null) {
            return;
        }

        WaimaiOrderMapping orderMapping = findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, WaimaiConstants.PlatformType.BAIDU);
        if (orderMapping == null) {
            return;
        }

        OrderService orderService = bdWmClient.getOrderService();

        //完成百度订单
        try {
            orderService.complete(orderMapping.getTargetId());
        } catch (BdWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {

    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {

    }
}
