package com.ptteng.onway.platform.service.waimai.dish.impls;

import com.alibaba.fastjson.JSONArray;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.google.common.collect.Lists;
import com.jiabangou.mtwmsdk.api.FoodService;
import com.jiabangou.mtwmsdk.api.ImageService;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.*;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.dish.WaimaiDishService;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishCategoryMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Created by wanglei on 16-10-9.
 */
public class MeituanDishServiceImpl extends MeituanAbstractService implements WaimaiDishService {

    private static Logger logger = Logger.getLogger(MeituanDishServiceImpl.class);

    private static final String DEFAULT_MEITUAN_CATEGORY_ID = "0";

    private static final String DEFAULT_MEITUAN_DISH_ID = "0";

    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }
        MtWmClient mtWmClient = getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }
        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        FoodCategory foodCategory = new FoodCategory();
        foodCategory.setApp_poi_code(storeMapping.getMappingId());
        foodCategory.setCategory_name(dishGroup.getName());
        foodCategory.setCategory_name_origin(dishGroup.getOldName());
        foodCategory.setSequence(String.valueOf(-dishGroup.getGroupRank()));

        try {
            FoodService foodService = mtWmClient.getFoodService();
            foodService.updateCategory(foodCategory);
            saveDishCategoryMapping(mchId, storeId, dishGroupId, foodCategory.getCategory_name(),
                    DEFAULT_MEITUAN_CATEGORY_ID, WaimaiConstants.PlatformType.MEITUAN);
        } catch (MtWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }

    }

    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
    }

    @Override
    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        if (!checkDishPlatformById(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }
        MtWmClient mtWmClient = getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        if (Objects.isNull(dishNormWmDTO.getDishGroupWmDTO())) {
            //未加入分类的食物就直接删除
            return;
        }
        DishGroupWmDTO category = dishNormWmDTO.getDishGroupWmDTO();
        WaimaiDishCategoryMapping dishCategoryMapping = findDishCategoryMapping(mchId, storeId, category.getId(),
                WaimaiConstants.PlatformType.MEITUAN);
        if (dishCategoryMapping == null) {
            saveDishCategoryMapping(mchId, storeId, category.getId(), category.getName(),
                    DEFAULT_MEITUAN_CATEGORY_ID, WaimaiConstants.PlatformType.MEITUAN);
        }

        WaimaiDishMapping dishMapping = findDishMapping(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN);

        try {
            FoodService foodService = mtWmClient.getFoodService();
            ImageService imageService = mtWmClient.getImageService();
            Food food = buildFoodSave(dishNormId, storeMapping, dishNormWmDTO, imageService);
            if (dishMapping == null) {
                addDishMapping(mchId, storeId, dishNormId, DEFAULT_MEITUAN_DISH_ID, WaimaiConstants.PlatformType.MEITUAN);
            }
            foodService.initdata(food);
        } catch (MtWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    private Food buildFoodSave(Long dishNormId, WaimaiStoreMapping storeMapping, DishNormWmDTO dishNormWmDTO,
                               ImageService imageService) throws MtWmErrorException {
        Food food = new Food();
        food.setApp_poi_code(storeMapping.getMappingId());
        food.setApp_food_code(String.valueOf(dishNormId));
        food.setName(dishNormWmDTO.getName());
        food.setPrice(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPrice())));
        food.setMin_order_count(dishNormWmDTO.getMinOrderNum());
        food.setBox_num(Float.valueOf(dishNormWmDTO.getPackageBoxNum()));
        food.setBox_price(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPackageFee())));
        food.setCategory_name(dishNormWmDTO.getDishGroupWmDTO().getName());
        food.setIs_sold_out(0);
        food.setSequence(-dishNormWmDTO.getDishGroupWmDTO().getRank().intValue());
        String imageName = dishNormWmDTO.getPic().substring(dishNormWmDTO.getPic().lastIndexOf("/") + 1);
        if(!imageName.contains(".jpg")){
            String imageType = imageName.substring(imageName.lastIndexOf("."));
            imageName = imageName.replace(imageType, ".jpg");
        }
        String picture = imageService.uploadImage(storeMapping.getMappingId(), imageName, dishNormWmDTO.getPic() +
                WaimaiConstants.ImgStyle.MEITUAN_IMG_STYLE);
        food.setPicture(picture);

        //设置菜品sku为了设置库存
        Sku sku = new Sku();
        sku.setSku_id(String.valueOf(dishNormId));
        sku.setSpec(dishNormWmDTO.getName());
        sku.setPrice(Double.valueOf(CommonUtil.fenChangeY(dishNormWmDTO.getPrice())));
        sku.setStock(dishNormWmDTO.getStock());
        setAvailableTime(dishNormWmDTO, sku);
        List<Sku> skus = new ArrayList<>();
        skus.add(sku);
        food.setSkus(skus);
        return food;
    }

    private void setAvailableTime(DishNormWmDTO dishNormWmDTO, Sku sku) {
        String deliveryTime = dishNormWmDTO.getAvailableTimes();
        if (StringUtil.isNotEmpty(deliveryTime)) {
            sku.setAvailable_times(JSONArray.parseObject(deliveryTime, AvailableTimes.class));
        }
    }

    @Override
    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException{

        if (!checkDishPlatformById(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }
        MtWmClient mtWmClient = getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        WaimaiDishMapping dishMapping = findDishMapping(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN);

        if (dishMapping == null) {
            return;
        }

        try {
            FoodService foodService = mtWmClient.getFoodService();
            Food food = new Food();
            food.setApp_poi_code(String.valueOf(storeId));
            food.setApp_food_code(String.valueOf(dishNormId));
            food.setIs_sold_out(1);
            foodService.initdata(food);
        } catch (MtWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException{
        if (!checkDishPlatformById(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }
        MtWmClient mtWmClient = getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        if (Objects.isNull(dishNormWmDTO.getDishGroupWmDTO())) {
            //未加入分类的食物就直接删除
            return;
        }
        DishGroupWmDTO category = dishNormWmDTO.getDishGroupWmDTO();
        WaimaiDishCategoryMapping dishCategoryMapping = findDishCategoryMapping(mchId, storeId, category.getId(),
                WaimaiConstants.PlatformType.MEITUAN);
        if (dishCategoryMapping == null) {
            saveDishCategoryMapping(mchId, storeId, category.getId(), category.getName(),
                    DEFAULT_MEITUAN_CATEGORY_ID, WaimaiConstants.PlatformType.MEITUAN);
        }

        WaimaiDishMapping dishMapping = findDishMapping(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN);

        if (dishMapping == null) {
            return;
        }

        try {
            FoodService foodService = mtWmClient.getFoodService();
            ImageService imageService = mtWmClient.getImageService();
            Food food = buildFoodSave(dishNormId, storeMapping, dishNormWmDTO, imageService);
            foodService.initdata(food);
        } catch (MtWmErrorException bdWmErrorException) {
            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
        }
    }

    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        for (DishNormWmDTO dishNormWmDTO: dishNormWmDTOs){
            updateDish(mchId, storeId, dishNormWmDTO.getDishNormId(), dishNormWmDTO);
        }
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {

        if (!checkDishPlatformById(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }
        MtWmClient mtWmClient = getMtWmClient(mchId);
        if (mtWmClient == null) {
            return;
        }

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);
        if (storeMapping == null) {
            return;
        }

        WaimaiDishMapping dishMapping = findDishMapping(mchId, storeId, dishNormId, WaimaiConstants.PlatformType.MEITUAN);
        if (null == dishMapping) {
            return;
        }

        FoodService foodService = mtWmClient.getFoodService();
        try {

            List<Sku> skus = Lists.newArrayList();
            Sku sku = new Sku();
            sku.setSku_id(dishMapping.getMappingId());
            sku.setStock(stock);
            skus.add(sku);
            FoodSkuStock foodSkuStock = new FoodSkuStock();
            foodSkuStock.setApp_food_code(dishMapping.getMappingId());
            foodSkuStock.setSkus(skus);
            List<FoodSkuStock> foodSkuStocks = Lists.newArrayList();
            foodSkuStocks.add(foodSkuStock);

            foodService.updateSkuStock(storeMapping.getMappingId(), foodSkuStocks);
        } catch (MtWmErrorException e) {
            logger.error(e.getMessage(), e);
        }
    }

}
