package com.ptteng.onway.platform.service.waimai.dish.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Sets;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.WaimaiDishConsumerService;
import com.ptteng.onway.platform.service.waimai.dish.WaimaiDishService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.List;
import java.util.Set;

/**
 * 菜品消费者服务实现
 * Created by freeway on 16/7/22.
 */
public class DishConsumerServiceImpl implements WaimaiDishConsumerService {

    @Autowired
    @Qualifier("meituanDishService")
    private WaimaiDishService meituanDishService;

    private static Set<WaimaiDishService> waimaiDishServices = Sets.newHashSet();

    private Set<WaimaiDishService> getWaimaiDishServices(){
        if(CollectionUtils.isEmpty(waimaiDishServices)){
            waimaiDishServices.add(meituanDishService);
        }
        return waimaiDishServices;
    }

    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        for(WaimaiDishService s: getWaimaiDishServices()){
            s.saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
        }
    }

    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.updateDishGroup(mchId, storeId, dishGroupId, dishGroup);
        }
    }

    @Override
    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException{
        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.onlineDish(mchId, storeId, dishNormId, dishNormWmDTO);
        }
    }

    @Override
    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException {
        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.offlineDish(mchId, storeId, dishNormId);
        }
    }

    @Override
    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.updateDish(mchId, storeId, dishNormId, dishNormWmDTO);
        }
    }

    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.batchUpdateDish(mchId, storeId, dishNormWmDTOs);
        }
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {

        for(WaimaiDishService s: getWaimaiDishServices()) {
            s.setThreshold(mchId, storeId, dishNormId, stock);
        }
    }

}
