package com.ptteng.onway.platform.service.waimai;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.TrademarkParamsRelation;
import com.ptteng.onway.platform.service.impl.TrademarkParamsRelationServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import eleme.openapi.sdk.api.service.OrderService;
import eleme.openapi.sdk.api.service.ProductService;
import eleme.openapi.sdk.api.service.ShopService;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.OAuthClient;
import eleme.openapi.sdk.oauth.response.Token;
import eleme.openapi.sdk.utils.PropertiesUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Author wanglei
 * Created on 18-1-9
 */
public class ElemeAbstractService extends WaimaiAbstractService {

    private Logger logger = Logger.getLogger(BaiduAbstractService.class);

    // 设置是否沙箱环境
    private static final boolean isSandbox = true;
    // 设置APPKEY
    // 初始化OAuthClient
    private OAuthClient client = null;
    private Map<String, String> tokenMap = new HashMap<String, String>();

    @Autowired
    @Qualifier("trademarkParamsRelationService")
    private TrademarkParamsRelationServiceImpl trademarkParamsRelationService;

    public ElemeClient getElemeClient(Long mchId) throws ServiceException, ServiceDaoException {
        List<Long> ids =  trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatform(mchId,
                WaimaiConstants.PlatformType.ELEME, 0, 1);

        if(CollectionUtils.isEmpty(ids)){
            throw new ServiceException("trademarkParamsRelation is null ! mch id is :" + String.valueOf(mchId));
        }

        List<TrademarkParamsRelation> trademarkParamsRelations = trademarkParamsRelationService.getObjectsByIds(ids);

        if(CollectionUtils.isEmpty(trademarkParamsRelations)){
            throw new ServiceException("trademarkParamsRelation is null ! id is :" + String.valueOf(ids.get(0)));
        }

        TrademarkParamsRelation trademarkParamsRelation = trademarkParamsRelations.get(0);

        Config config = new Config(isSandbox, trademarkParamsRelation.getAppid(), trademarkParamsRelation.getSecret());
        client = new OAuthClient(config);
        clientToken();

        ShopService shopService = new ShopService(config, getToken());
        ProductService productService = new ProductService(config, getToken());
        OrderService orderService = new OrderService(config, getToken());

        ElemeClient elemeClient = new ElemeClient();
        elemeClient.setShopService(shopService);
        elemeClient.setProductService(productService);
        elemeClient.setOrderService(orderService);

        return elemeClient;
    }

    private Token getToken() {
        String access_token = PropertiesUtils.getPropValueByKey("access_token");
        String token_type = PropertiesUtils.getPropValueByKey("token_type");
        String expires_in = PropertiesUtils.getPropValueByKey("expires_in");
        String refresh_token = PropertiesUtils.getPropValueByKey("refresh_token");
        if (access_token.isEmpty()) {
            System.out.println("access_token is null");
            return null;
        }
        Token token = new Token();
        token.setAccessToken(access_token);
        token.setTokenType(token_type);
        token.setExpires(Long.valueOf(expires_in));
        token.setRefreshToken(refresh_token);
        return token;
    }

    private void setTokenInfo(Token token) {
        if (null != token && token.isSuccess()) {
            tokenMap.put("access_token", token.getAccessToken());
            tokenMap.put("token_type", token.getTokenType());
            tokenMap.put("expires_in", String.valueOf(token.getExpires()));
            tokenMap.put("refresh_token", token.getRefreshToken());
            PropertiesUtils.setProps(tokenMap);
        }
    }

    private void clientToken() {
        Token token = client.getTokenInClientCredentials();
        if (token.isSuccess()) {
            setTokenInfo(token);
            System.out.println(token);
        } else {
            System.out.println("error_code: " + token.getError());
            System.out.println("error_desc: " + token.getError_description());
        }
    }

}
