package com.ptteng.onway.platform.service.waimai;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.impl.BdWmClientImpl;
import com.jiabangou.bdwmsdk.api.impl.BdWmInMemoryConfigStorage;
import com.ptteng.onway.platform.model.TrademarkParamsRelation;
import com.ptteng.onway.platform.service.impl.TrademarkParamsRelationServiceImpl;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.List;

/**
 * 百度外卖抽象服务
 * Created by freeway on 16/7/27.
 */
public abstract class BaiduAbstractService extends WaimaiAbstractService {

    private Logger logger = Logger.getLogger(BaiduAbstractService.class);

    @Autowired
    @Qualifier("trademarkParamsRelationService")
    private TrademarkParamsRelationServiceImpl trademarkParamsRelationService;

    public BdWmClient getBdWmClient(Long mchId) throws ServiceException, ServiceDaoException {

        List<Long> ids =  trademarkParamsRelationService.getTrademarkParamsRelationIdsByTrademarkIdAndPlatform(mchId,
                WaimaiConstants.PlatformType.BAIDU, 0, 1);

        if(CollectionUtils.isEmpty(ids)){
            throw new ServiceException("trademarkParamsRelation is null ! mch id is :" + String.valueOf(mchId));
        }

        List<TrademarkParamsRelation> trademarkParamsRelations = trademarkParamsRelationService.getObjectsByIds(ids);

        if(CollectionUtils.isEmpty(trademarkParamsRelations)){
            throw new ServiceException("trademarkParamsRelation is null ! id is :" + String.valueOf(ids.get(0)));
        }

        TrademarkParamsRelation trademarkParamsRelation = trademarkParamsRelations.get(0);

        BdWmClient client = new BdWmClientImpl();
        BdWmInMemoryConfigStorage baiduWaimaiConfigStorage = new BdWmInMemoryConfigStorage();
        baiduWaimaiConfigStorage.setSource(trademarkParamsRelation.getAppid());
        baiduWaimaiConfigStorage.setSecret(trademarkParamsRelation.getSecret());
        client.setBaiduWaimaiConfigStorage(baiduWaimaiConfigStorage);
//        client.setLogListener((String cmd, String method, boolean isSuccess, String request, String response) -> {
//            logger.info("cmd:" + cmd + "\n" + "isSuccess:" + isSuccess + "\n" +
//                    "request:" + request + "\n" + "response:" + response);
//            super.log(cmd, method, isSuccess, request, response);
//
//        });
        return client;
    }

}
