package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.UserOrder;
import com.ptteng.onway.platform.service.UserOrderService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserOrderServiceImpl extends BaseDaoServiceImpl implements UserOrderService {



	private static final Log log = LogFactory.getLog(UserOrderServiceImpl.class);




	@Override
	public Long insert(UserOrder userOrder)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + userOrder);

		if (userOrder == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userOrder.setCreateAt(currentTimeMillis);
		userOrder.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userOrder);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<UserOrder> insertList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (userOrderList == null ? "null" : userOrderList.size()));

		List<UserOrder> resultList = null;

		if (CollectionUtils.isEmpty(userOrderList)) {
			return new ArrayList<UserOrder>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserOrder userOrder : userOrderList) {
			userOrder.setCreateAt(currentTimeMillis);
			userOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserOrder>) dao.batchSave(userOrderList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserOrder.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(UserOrder userOrder)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (userOrder == null ? "null" : userOrder.getId()));

		boolean result = false;

		if (userOrder == null) {
			return true;
		}

		userOrder.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userOrder);
		} catch (DaoException e) {
			log.error(" update wrong : " + userOrder);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + userOrder);
		}
		return result;
	}


	@Override
	public boolean updateList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (userOrderList == null ? "null" : userOrderList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userOrderList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserOrder userOrder : userOrderList) {
			userOrder.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userOrderList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userOrderList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + userOrderList.size());

		return result;
	}


	@Override
	public UserOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		UserOrder userOrder = null;

		if (id == null) {
			return userOrder;
		}

		try {
			userOrder = (UserOrder) dao.get(UserOrder.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return userOrder;
	}


	@Override
	public List<UserOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<UserOrder> userOrder = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserOrder>();
		}

		try {
			userOrder = (List<UserOrder>) dao.getList(UserOrder.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (userOrder == null ? "null" : userOrder.size()));

		return userOrder;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByPlatform(String platform,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by platform,start,limit  : " + platform+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByPlatform", new Object[] { platform},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by platform,start,limit)  : " + platform+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserOrderIdByOrderNum(Long orderNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by orderNum  : " + orderNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getUserOrderIdByOrderNum", new Object[] {orderNum });
		} catch (DaoException e) {
			log.error(" get id wrong by orderNum  : " + orderNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserOrderIdByPlatformOrderNum(String platformOrderNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by platformOrderNum  : " + platformOrderNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getUserOrderIdByPlatformOrderNum", new Object[] {platformOrderNum });
		} catch (DaoException e) {
			log.error(" get id wrong by platformOrderNum  : " + platformOrderNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserOrderIdByPlatformOrderId(String platformOrderId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by platformOrderNum  : " + platformOrderId );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getUserOrderIdByPlatformOrderId", new Object[] {platformOrderId });
		} catch (DaoException e) {
			log.error(" get id wrong by platformOrderId  : " + platformOrderId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdByPlatformOrderIds(String platformOrderIds,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by platformOrderIds : " + platformOrderIds);
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdByPlatformOrderIds", new Object[] { platformOrderIds},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by platformOrderIds,start,limit)  : " + platformOrderIds+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByBuyAt(Long startBuyAt,Long endBuyAt,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by startBuyAt,endBuyAt,start,limit  : " + startBuyAt+" , "+endBuyAt+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByBuyAt", new Object[] { startBuyAt,endBuyAt},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by startBuyAt,endBuyAt,start,limit)  : " + startBuyAt+" , "+endBuyAt+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkId,start,limit  : " + trademarkId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByTrademarkId", new Object[] { trademarkId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus,Integer orderStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by acceptStatus,orderStatus,start,limit  : " + acceptStatus+" , "+orderStatus+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByAcceptStatusAndOrderStatus", new Object[] { acceptStatus,orderStatus},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by acceptStatus,orderStatus,start,limit)  : " + acceptStatus+" , "+orderStatus+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByStoreId(Long storeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeId,start,limit  : " + storeId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByStoreId", new Object[] { storeId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeId,start,limit)  : " + storeId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

	/**
	 *
	 * @params
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@Override
	public List<Long>  getUserOrderIdsByStoreIdAcceptStatus(Long storeId,Integer acceptStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeId,acceptStatus,start,limit  : " + storeId+" , "+acceptStatus+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsByStoreIdAcceptStatus", new Object[] { storeId,acceptStatus},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeId,start,limit)  : " + storeId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByPlatform(String platform)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by platform  : " + platform );
		}
		Integer count=null;



		try {

			count = dao.count("getUserOrderIdsByPlatform", new Object[] { platform});


		} catch (DaoException e) {
			log.error(" count ids  wrong by platform)  : " + platform );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByBuyAt(Long startBuyAt,Long endBuyAt)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by startBuyAt,endBuyAt  : " + startBuyAt+" , "+endBuyAt );
		}
		Integer count=null;



		try {

			count = dao.count("getUserOrderIdsByBuyAt", new Object[] { startBuyAt,endBuyAt});


		} catch (DaoException e) {
			log.error(" count ids  wrong by startBuyAt,endBuyAt)  : " + startBuyAt+" , "+endBuyAt );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkId  : " + trademarkId );
		}
		Integer count=null;



		try {

			count = dao.count("getUserOrderIdsByTrademarkId", new Object[] { trademarkId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkId)  : " + trademarkId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus,Integer orderStatus)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by acceptStatus,orderStatus  : " + acceptStatus+" , "+orderStatus );
		}
		Integer count=null;



		try {

			count = dao.count("getUserOrderIdsByAcceptStatusAndOrderStatus", new Object[] { acceptStatus,orderStatus});


		} catch (DaoException e) {
			log.error(" count ids  wrong by acceptStatus,orderStatus)  : " + acceptStatus+" , "+orderStatus );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByStoreId(Long storeId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by storeId  : " + storeId );
		}
		Integer count=null;



		try {

			count = dao.count("getUserOrderIdsByStoreId", new Object[] { storeId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by storeId)  : " + storeId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getUserOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserOrderIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countUserOrderIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserOrderIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserOrderIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

