package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.Trademark;
import com.ptteng.onway.platform.service.TrademarkService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class TrademarkServiceImpl extends BaseDaoServiceImpl implements TrademarkService {



	private static final Log log = LogFactory.getLog(TrademarkServiceImpl.class);




	@Override
	public Long insert(Trademark trademark)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + trademark);

		if (trademark == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		trademark.setCreateAt(currentTimeMillis);
		trademark.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(trademark);
		} catch (DaoException e) {
			log.error(" insert wrong : " + trademark);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Trademark> insertList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (trademarkList == null ? "null" : trademarkList.size()));

		List<Trademark> resultList = null;

		if (CollectionUtils.isEmpty(trademarkList)) {
			return new ArrayList<Trademark>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Trademark trademark : trademarkList) {
			trademark.setCreateAt(currentTimeMillis);
			trademark.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Trademark>) dao.batchSave(trademarkList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + trademarkList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Trademark.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Trademark trademark)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (trademark == null ? "null" : trademark.getId()));

		boolean result = false;

		if (trademark == null) {
			return true;
		}

		trademark.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(trademark);
		} catch (DaoException e) {
			log.error(" update wrong : " + trademark);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + trademark);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (trademarkList == null ? "null" : trademarkList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(trademarkList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Trademark trademark : trademarkList) {
			trademark.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(trademarkList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + trademarkList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + trademarkList.size());

		return result;
	}


	@Override
	public Trademark getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Trademark trademark = null;

		if (id == null) {
			return trademark;
		}

		try {
			trademark = (Trademark) dao.get(Trademark.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return trademark;
	}


	@Override
	public List<Trademark> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Trademark> trademark = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Trademark>();
		}

		try {
			trademark = (List<Trademark>) dao.getList(Trademark.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (trademark == null ? "null" : trademark.size()));

		return trademark;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getTrademarkIdByName(String name)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by name  : " + name );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getTrademarkIdByName", new Object[] {name });
		} catch (DaoException e) {
			log.error(" get id wrong by name  : " + name );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long getTrademarkByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkNum : " + trademarkNum);
		}
		Long id = null;

		// TODO 参数检查!

		try {
			id = (Long) dao.getMapping("getTrademarkIdsByTrademarkNum", new Object[] { trademarkNum});


		} catch (DaoException e) {
			log.error(" get id wrong by trademarkNum)  : " + trademarkNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : id is " +id);
		}
		return id;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countTrademarkIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkNum  : " + trademarkNum );
		}
		Integer count=null;



		try {

			count = dao.count("getTrademarkIdsByTrademarkNum", new Object[] { trademarkNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkNum)  : " + trademarkNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getTrademarkIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTrademarkIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countTrademarkIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getTrademarkIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getTrademarkIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

