package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.TrademarkParamsRelation;
import com.ptteng.onway.platform.service.TrademarkParamsRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class TrademarkParamsRelationServiceImpl extends BaseDaoServiceImpl implements TrademarkParamsRelationService {



	private static final Log log = LogFactory.getLog(TrademarkParamsRelationServiceImpl.class);




	@Override
	public Long insert(TrademarkParamsRelation trademarkParamsRelation)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + trademarkParamsRelation);

		if (trademarkParamsRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		trademarkParamsRelation.setCreateAt(currentTimeMillis);
		trademarkParamsRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(trademarkParamsRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + trademarkParamsRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<TrademarkParamsRelation> insertList(List<TrademarkParamsRelation> trademarkParamsRelationList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (trademarkParamsRelationList == null ? "null" : trademarkParamsRelationList.size()));

		List<TrademarkParamsRelation> resultList = null;

		if (CollectionUtils.isEmpty(trademarkParamsRelationList)) {
			return new ArrayList<TrademarkParamsRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (TrademarkParamsRelation trademarkParamsRelation : trademarkParamsRelationList) {
			trademarkParamsRelation.setCreateAt(currentTimeMillis);
			trademarkParamsRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<TrademarkParamsRelation>) dao.batchSave(trademarkParamsRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + trademarkParamsRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(TrademarkParamsRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(TrademarkParamsRelation trademarkParamsRelation)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (trademarkParamsRelation == null ? "null" : trademarkParamsRelation.getId()));

		boolean result = false;

		if (trademarkParamsRelation == null) {
			return true;
		}

		trademarkParamsRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(trademarkParamsRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + trademarkParamsRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + trademarkParamsRelation);
		}
		return result;
	}


	@Override
	public boolean updateList(List<TrademarkParamsRelation> trademarkParamsRelationList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (trademarkParamsRelationList == null ? "null" : trademarkParamsRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(trademarkParamsRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (TrademarkParamsRelation trademarkParamsRelation : trademarkParamsRelationList) {
			trademarkParamsRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(trademarkParamsRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + trademarkParamsRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + trademarkParamsRelationList.size());

		return result;
	}


	@Override
	public TrademarkParamsRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		TrademarkParamsRelation trademarkParamsRelation = null;

		if (id == null) {
			return trademarkParamsRelation;
		}

		try {
			trademarkParamsRelation = (TrademarkParamsRelation) dao.get(TrademarkParamsRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return trademarkParamsRelation;
	}


	@Override
	public List<TrademarkParamsRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<TrademarkParamsRelation> trademarkParamsRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<TrademarkParamsRelation>();
		}

		try {
			trademarkParamsRelation = (List<TrademarkParamsRelation>) dao.getList(TrademarkParamsRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (trademarkParamsRelation == null ? "null" : trademarkParamsRelation.size()));

		return trademarkParamsRelation;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getTrademarkParamsRelationIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkId,start,limit  : " + trademarkId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTrademarkParamsRelationIdsByTrademarkId", new Object[] { trademarkId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getTrademarkParamsRelationIdsByTrademarkIdAndPlatform(Long trademarkId,String platform,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkId,start,limit  : " + trademarkId+" , "+platform+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTrademarkParamsRelationIdsByTrademarkIdAndPlatform", new Object[] { trademarkId,platform},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getTrademarkParamsRelationIdsByTrademarkIdAndPlatformAndType(Long trademarkId,String platform,Integer type)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkId,type,start,limit  : " + trademarkId+" , "+platform+" , "+" , "+type);
		}
		Long id = null;

		// TODO 参数检查!


		try {
			id = (Long) dao.getMapping("getTrademarkParamsRelationIdsByTrademarkIdAndPlatformAndType", new Object[] { trademarkId,platform,type});


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,platform,type)  : " + trademarkId+" , " +platform+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + (id == null ? "null" :id));
		}
		return id;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getTrademarkParamsRelationIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkNum,start,limit  : " + trademarkNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTrademarkParamsRelationIdsByTrademarkNum", new Object[] { trademarkNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkNum,start,limit)  : " + trademarkNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countTrademarkParamsRelationIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkId  : " + trademarkId );
		}
		Integer count=null;



		try {

			count = dao.count("getTrademarkParamsRelationIdsByTrademarkId", new Object[] { trademarkId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkId)  : " + trademarkId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countTrademarkParamsRelationIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkNum  : " + trademarkNum );
		}
		Integer count=null;



		try {

			count = dao.count("getTrademarkParamsRelationIdsByTrademarkNum", new Object[] { trademarkNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkNum)  : " + trademarkNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getTrademarkParamsRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTrademarkParamsRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countTrademarkParamsRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getTrademarkParamsRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getTrademarkParamsRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

