package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.*;
import com.ptteng.onway.platform.service.TemplateTestService;
import com.qding.common.util.DataUtils;
import com.sleepycat.je.tree.IN;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.List;

/**
 * Created by ${zhangfan} on 2017/11/7.
 */
//实现了的那个接口要写上,否则web模块报错找不到相关的bean
public class TemplateTestServiceImpl implements TemplateTestService {
    private static final Log log = LogFactory.getLog(TemplateTestServiceImpl.class);
    private JdbcTemplate template;

    public JdbcTemplate getTemplate() {
        return template;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }


    @Override
    public List<OrderStatistics> getOrderStatisticsByTimeAndStoreId(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        log.info("getOrderStatisticsByTimeAndStoreId start_at is " + start_at + " , end_at is " + end_at + " storeId is " + storeId);

        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE store_id = ? GROUP BY  platform";

        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {

            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, storeId);

        } else if (DataUtils.isNotNullOrEmpty(start_at)) {

            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and store_id = ? GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, storeId);

        } else if (DataUtils.isNotNullOrEmpty(end_at)) {

            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and store_id = ? GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, storeId);
        }

        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), storeId);

    }

    @Override
    public List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkId(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? GROUP BY  platform,store_id";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? GROUP BY  platform  ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }

    @Override
    public List<OrderStatistics> getOrderStatisticsByTimeAndStoreIdAndOrderStatus(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform  ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, storeId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), storeId);
    }


    @Override
    public List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform,store_id";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform  ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }


    @Override
    public List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkId(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? GROUP BY store_id";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? GROUP BY store_id";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? GROUP BY store_id";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? GROUP BY store_id";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }

    @Override
    public List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreId(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE store_id = ?";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ?";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and store_id = ? ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and store_id = ? ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, storeId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), storeId);
    }

    @Override
    public List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id  ";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }
        log.info("sql is " + sql + " trademarkId is " + trademarkId);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }

    @Override
    public List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE store_id = ? AND order_status IN (2,3) AND accept_status = 2";
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, storeId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, storeId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), storeId);
    }


    @Override
    public List<OrderStatistics> getTrademarkOrderStatisticsByTimeAndOrderStatus(Long start_at, Long end_at, Long trademarkId, Integer orderType) throws ServiceException, ServiceDaoException {
        String sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(start_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);
        } else if (DataUtils.isNotNullOrEmpty(end_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }
        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }

    @Override
    public List<OrderStatistics> getTrademarkOrderStatisticsByPlatform(Long start_at, Long end_at, Long trademarkId, Integer orderType) throws ServiceException, ServiceDaoException {
        String sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";

        if (DataUtils.isNotNullOrEmpty(start_at) && DataUtils.isNotNullOrEmpty(end_at)) {

            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, end_at, trademarkId);

        } else if (DataUtils.isNotNullOrEmpty(start_at)) {

            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), start_at, trademarkId);

        } else if (DataUtils.isNotNullOrEmpty(end_at)) {

            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), end_at, trademarkId);
        }

        log.info("sql is " + sql);
        return (List<OrderStatistics>) template.query(sql, new BeanPropertyRowMapper(OrderStatistics.class), trademarkId);
    }


    /**
    * 菜品统计*/
    @Override
    public List<FoodStatistics> getTrademarkFoodStatisticsByTime(Long startAt, Long endAt, Long trademarkId) throws ServiceException, ServiceDaoException {

        String sql = "SELECT b.trademark_id id," +
                "sum(quantity)quantity," +
                "sum(price*quantity)price," +
                "sum(quantity*price*(1-food_discount))discountAmount," +
                "(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? )cancelCount," +
                "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? )cancelAmount " +
                "FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND a.trademark_id = ? ";

        if (DataUtils.isNotNullOrEmpty(startAt) && DataUtils.isNotNullOrEmpty(endAt)){

             sql = "SELECT b.trademark_id id," +
                     "sum(quantity)quantity," +
                     "sum(price*quantity)price," +
                     "sum(quantity*price*(1-food_discount))discountAmount," +
                     "(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at >= ? and buy_at <= ? )cancelCount," +
                     "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? and u.buy_at >= ? and u.buy_at <= ? )cancelAmount" +
                     " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? and b.buy_at <= ? AND a.trademark_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), trademarkId,startAt,endAt,trademarkId,startAt,endAt,startAt,endAt,trademarkId);

        } else if (DataUtils.isNotNullOrEmpty(startAt)) {
            sql = "SELECT b.trademark_id id," +
                    "sum(quantity)quantity," +
                    "sum(price*quantity)price," +
                    "sum(quantity*price*(1-food_discount))discountAmount," +
                    "(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at >= ? )cancelCount," +
                    "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? and u.buy_at >= ? )cancelAmount" +
                    " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? AND a.trademark_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), trademarkId,startAt,trademarkId,startAt,startAt,trademarkId);

        }else if (DataUtils.isNotNullOrEmpty(endAt)) {
            sql = "SELECT b.trademark_id id," +
                    "sum(quantity)quantity," +
                    "sum(price*quantity)price," +
                    "sum(quantity*price*(1-food_discount))discountAmount," +
                    "(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at <= ? )cancelCount," +
                    "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and u.trademark_id = ? and u.buy_at <= ? )cancelAmount" +
                    " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at <= ? AND b.trademark_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), trademarkId,endAt,trademarkId,endAt,endAt,trademarkId);

        }

        return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), trademarkId,trademarkId,trademarkId);
    }

    @Override
    public List<FoodStatistics> getStoreFoodStatisticsByTime(Long startAt, Long endAt, Long storeId) throws ServiceException, ServiceDaoException {

        String sql = "SELECT b.store_id id," +
                "sum(quantity)quantity," +
                "sum(price*quantity)price," +
                "sum(quantity*price*(1-food_discount))discountAmount," +
                "(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? )cancelCount," +
                "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? )cancelAmount " +
                "FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND a.store_id = ? ";

        if (DataUtils.isNotNullOrEmpty(startAt) && DataUtils.isNotNullOrEmpty(endAt)){

             sql = "SELECT b.store_id id," +
                     "sum(quantity)quantity," +
                     "sum(price*quantity)price," +
                     "sum(quantity*price*(1-food_discount))discountAmount," +
                     "(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at >= ? and buy_at <= ? )cancelCount," +
                     "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at >= ? and u.buy_at <= ? )cancelAmount" +
                     " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? and b.buy_at <= ? AND a.store_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), storeId,startAt,endAt,storeId,startAt,endAt,startAt,endAt,storeId);

        } else if (DataUtils.isNotNullOrEmpty(startAt)) {
            sql = "SELECT b.store_id id," +
                    "sum(quantity)quantity," +
                    "sum(price*quantity)price," +
                    "sum(quantity*price*(1-food_discount))discountAmount," +
                    "(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at >= ? )cancelCount," +
                    "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at >= ? )cancelAmount" +
                    " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? AND a.store_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), storeId,startAt,storeId,startAt,startAt,storeId);

        }else if (DataUtils.isNotNullOrEmpty(endAt)) {
            sql = "SELECT b.store_id id," +
                    "sum(quantity)quantity," +
                    "sum(price*quantity)price," +
                    "sum(quantity*price*(1-food_discount))discountAmount," +
                    "(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at <= ? )cancelCount," +
                    "(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at <= ? )cancelAmount" +
                    " FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at <= ? AND a.store_id = ? ";
            return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), storeId,endAt,storeId,endAt,endAt,storeId);

        }

        return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class), storeId,storeId,storeId);
    }

    @Override
    public List<FoodStatistics> getStoreFoodStatisticsDetailBuyTime(Long startAt, Long endAt, Long storeId, Integer sort,Integer foodType) throws ServiceException, ServiceDaoException {
        log.info(" startAt is "+startAt +" ,endAt is "+endAt + " ,storeId is " +storeId +" , sort is " +sort+ " , foodType is " +foodType);
        String orderWord = "quantity";
        /*排序字段*/


        if (DataUtils.isNotNullOrEmpty(sort) && sort < 0){
            orderWord = orderWord + " DESC";
        }
        String startAtSql ="";
        String endAtSql ="";
        String typeSql ="";
        if(DataUtils.isNotNullOrEmpty(startAt)){
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        if(DataUtils.isNotNullOrEmpty(sort)){
            switch (sort) {
                case FoodStatistics.ORDER_MEITUAN:
                    orderWord = "meituanCount";
                    break;
                case FoodStatistics.ORDER_ELE:
                    orderWord = "baiduCount";
                    break;
                case FoodStatistics.ORDER_BAIDU:
                    orderWord = "eleCount";
                    break;
                case FoodStatistics.ORDER_QUANTITY:
                    orderWord = "quantity";
                    break;
                case FoodStatistics.ORDER_SALES_PROPORTION:
                    orderWord = "salesProportion";
                    break;
                case FoodStatistics.ORDER_SALES_AMOUNT:
                    orderWord = "salesAmount";
                    break;
                case FoodStatistics.ORDER_AMOUNT_PROPORTION:
                    orderWord = "amountProportion";
                    break;
                    default:
                        break;
            }
        }
        if (DataUtils.isNotNullOrEmpty(foodType)){
            typeSql = " AND f.food_type = " + foodType;
        }
        String sql = "SELECT" +
                "  f.id," +
                "  ft.name foodType,"+
                "  f.name," +
                "  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000001' AND o.order_status IN (2,3)  AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+" )meituanCount," +
                "  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000010' AND o.order_status IN (2,3) AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+")baiduCount," +
                "  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000100' AND o.order_status IN (2,3) AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+")eleCount," +
                "  sum(fr.quantity)quantity," +
                "  sum(fr.quantity/(SELECT sum(quantity) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status IN (2,3)) AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+")saleSProportion," +
                "  SUM(fr.quantity*fr.price)salesAmount," +
                "  SUM(fr.quantity*fr.price)/(SELECT SUM(fr.quantity*fr.price) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status IN (2,3) AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+")amountProportion," +
                "  sum(fr.quantity *fs.price* (1-fr.food_discount))discountAmount," +
                "  (SELECT sum(fr.quantity) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status=0 AND fr.food_id=f.id AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+") cancelCount," +
                "  (SELECT sum(fr.quantity*fr.price) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status=0 AND fr.food_id=f.id AND o.store_id="+storeId+startAtSql+endAtSql+typeSql+")cancelAmount " +
                "FROM food_order_relation AS fr,user_order AS o ,food AS f,food_type_relation AS ft, food_solid AS fs WHERE o.id=fr.order_id AND fr.food_id=f.id AND o.order_status IN (2,3) AND fs.group_num=ft.type_num AND f.food_num=fs.food_num AND o.store_id= "+storeId+startAtSql+endAtSql+typeSql+"  GROUP BY fr.food_id ORDER BY "+orderWord+";";
        log.info(" sql is :" + sql);
        return (List<FoodStatistics>) template.query(sql, new BeanPropertyRowMapper(FoodStatistics.class));
    }

    //用户统计
    @Override
    public List<UserStatistics> getUserStatisticsByTimeAndStoreId(Long startAt,Long endAt,Long storeId,Long trademarkId
            ){
        log.info(" startAt is "+startAt +" ,endAt is "+endAt + " ,storeId is " +storeId +" ,trademarkId is "+trademarkId );
        String startAtSql ="";
        String endAtSql ="";

        if(DataUtils.isNotNullOrEmpty(startAt)){
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql ="SELECT " +
                "o.store_id id," +  //门店id
                "s.name storeName, " +  //门店名
                "t.name trademarkName, " +  //品牌名
                "count(DISTINCT mobile) userCount, " +//总用户数
                "(SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.store_id=s.id AND o.trademark_id=t.id AND o.order_status in (2,3)) newUserCount, " +//新用户数
                "((SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.store_id=s.id AND o.trademark_id=t.id AND o.order_status in (2,3))/count(DISTINCT mobile)) newUserRate " +//新用户占比
                "FROM user_order AS o,store as s,trademark AS t " +
                "WHERE o.store_id=s.id AND o.trademark_id=t.id AND o.trademark_id = "+trademarkId+" AND o.order_status in (2,3) AND  o.store_id = "+storeId+startAtSql+endAtSql+" GROUP BY  store_id";

        log.info("sql is :" + sql);
        return (List<UserStatistics>) template.query(sql,new BeanPropertyRowMapper(UserStatistics.class));
    }

    @Override
    public List<UserStatistics> getUserStatisticsByTimeAndTrademarkId(Long startAt,Long endAt,Long trademarkId
            ){
        log.info(" startAt is "+startAt +" ,endAt is "+endAt + " ,trademarkId is "+trademarkId );
        String startAtSql ="";
        String endAtSql ="";




        if(DataUtils.isNotNullOrEmpty(startAt)){
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql ="SELECT " +
                "o.trademark_id id," +  //门店id
                "t.name trademarkName, " +  //品牌名
                "count(DISTINCT mobile) userCount, " +//总用户数
                "(SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.trademark_id=t.id AND o.order_status in (2,3)) newUserCount, " +//新用户数
                "((SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.trademark_id=t.id AND o.order_status in (2,3))/count(DISTINCT mobile)) newUserRate " +//新用户占比
                "FROM user_order AS o,trademark AS t " +
                "WHERE o.trademark_id=t.id AND o.trademark_id = "+trademarkId+" AND o.order_status in (2,3)"+startAtSql+endAtSql+" GROUP BY o.trademark_id";

        log.info("sql is :" + sql);
        return (List<UserStatistics>) template.query(sql,new BeanPropertyRowMapper(UserStatistics.class));
    }

    //各星级评价数统计
    @Override
    public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndStoreId (Long startAt, Long endAt, Long trademarkId, Long
            storeId) throws ServiceException,ServiceDaoException{
        log.info(" startAt is "+startAt +" ,endAt is "+endAt + " ,storeId is " +storeId );
        String startAtSql ="";
        String endAtSql ="";

        if(DataUtils.isNotNullOrEmpty(startAt)){
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            endAtSql = " AND o.buy_at <= " + endAt;
        }

        String sql ="SELECT " +
                "o.store_id storeId, "+//门店id
                "s.name storeName, "+//门店名
                "o.trademark_id trademarkId, "+//品牌id
                "t.name trademarkName, "+//品牌名
                "(select count(o.id) FROM user_order AS o " +
                "WHERE o.order_status = 3 AND o.store_id ="+storeId+" AND o.trademark_id ="+trademarkId+")orderCount, "+//外卖订单数
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order as o WHERE o.id=e.order_id and o.store_id="+storeId+") evaluateCount, "+//评价单数
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order as o WHERE o.id=e.order_id and o.store_id="+storeId+")/(select count(o.id) FROM user_order AS o " +
                "WHERE o.order_status = 3 AND o.store_id ="+storeId+" AND o.trademark_id ="+trademarkId+") evaluateRate, "+//评价率
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o WHERE o.order_status=3 and o.id=e.order_id and o.store_id = "+storeId+" and e.order_score=5) fiveCount, "+//五星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = "+storeId+" and e.order_score=4) fourCount, "+//四星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = "+storeId+" and e.order_score=3) threeCount, "+//三星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = "+storeId+"  and e.order_score=2) twoCount, "+//二星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = "+storeId+" and e.order_score=1) oneCount "+//一星评价
                "FROM user_order AS o,store AS s,trademark AS t,evaluate_order_relation AS e WHERE o.id=e.order_id AND o.order_status=3 AND o.store_id = "+storeId+" AND o.trademark_id ="+trademarkId+startAtSql+endAtSql + " GROUP BY o.store_id";

        log.info("sql is :" + sql);
        return (List<EvaluateStatistics>) template.query(sql,new BeanPropertyRowMapper(EvaluateStatistics.class));

    }
    //各星级评价数统计
    @Override
    public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndTrademarkId (Long startAt, Long endAt, Long trademarkId) throws ServiceException,ServiceDaoException{
        log.info(" startAt is "+startAt +" ,endAt is "+endAt + " ,trademarkId is " + trademarkId);
        String startAtSql ="";
        String endAtSql ="";

        if(DataUtils.isNotNullOrEmpty(startAt)){
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            endAtSql = " AND o.buy_at <= " + endAt;
        }

        String sql ="SELECT " +
                "o.trademark_id trademarkId, "+//品牌id
                "t.name trademarkName, "+//品牌名
                "(select count(o.id) FROM user_order AS o " +
                "WHERE o.order_status = 3 AND o.trademark_id ="+trademarkId+")orderCount, "+//外卖订单数
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e WHERE o.id=e.order_id) evaluateCount, "+//评价单数
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e WHERE o.id=e.order_id)/(select count(o.id) FROM user_order AS o " +
                "WHERE o.order_status = 3 AND o.trademark_id ="+trademarkId+") evaluateRate, "+//评价率
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=5) fiveCount, "+//五星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=4) fourCount, "+//四星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=3) threeCount, "+//三星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id  and e.order_score=2) twoCount, "+//二星评价
                "(SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=1) oneCount "+//一星评价
                "FROM user_order AS o,store AS s,trademark AS t,evaluate_order_relation AS e WHERE o.id=e.order_id AND o.order_status=3  AND o.trademark_id ="+trademarkId+startAtSql+endAtSql + " GROUP BY o.trademark_id";

        log.info("sql is :" + sql);
        return (List<EvaluateStatistics>) template.query(sql,new BeanPropertyRowMapper(EvaluateStatistics.class));

    }


}

