package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.SynRecord;
import com.ptteng.onway.platform.service.SynRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SynRecordServiceImpl extends BaseDaoServiceImpl implements SynRecordService {

 

	private static final Log log = LogFactory.getLog(SynRecordServiceImpl.class);



		   
		@Override
		public Long insert(SynRecord synRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + synRecord);

		if (synRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		synRecord.setCreateAt(currentTimeMillis);
		synRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(synRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + synRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<SynRecord> insertList(List<SynRecord> synRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (synRecordList == null ? "null" : synRecordList.size()));
      
		List<SynRecord> resultList = null;

		if (CollectionUtils.isEmpty(synRecordList)) {
			return new ArrayList<SynRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SynRecord synRecord : synRecordList) {
			synRecord.setCreateAt(currentTimeMillis);
			synRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<SynRecord>) dao.batchSave(synRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + synRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(SynRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(SynRecord synRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (synRecord == null ? "null" : synRecord.getId()));

		boolean result = false;

		if (synRecord == null) {
			return true;
		}

		synRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(synRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + synRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + synRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<SynRecord> synRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (synRecordList == null ? "null" : synRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(synRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SynRecord synRecord : synRecordList) {
			synRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(synRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + synRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + synRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public SynRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		SynRecord synRecord = null;

		if (id == null) {
			return synRecord;
		}

		try {
			synRecord = (SynRecord) dao.get(SynRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return synRecord;		
		}	
		  
    	   
		@Override
		public List<SynRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<SynRecord> synRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<SynRecord>();
		}

		try {
			synRecord = (List<SynRecord>) dao.getList(SynRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (synRecord == null ? "null" : synRecord.size()));
    
		return synRecord;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getSynRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSynRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
		@Override
	public List<Long> getSynRecordIdsByTypePlatformStoreId(Integer synType,String platform,Long storeId,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by synType,platform,storeId,start,limit  ================== " +synType+" , "+platform+" , "+storeId+" , "+ start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getSynRecordIdsByTypePlatformStoreId",new Object[] {synType,platform,storeId},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by type,tart,limit)  : "+ synType +" , "+ start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	
		@Override
	public Integer countSynRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSynRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSynRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

