package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.service.StoreService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class StoreServiceImpl extends BaseDaoServiceImpl implements StoreService {



	private static final Log log = LogFactory.getLog(StoreServiceImpl.class);




	@Override
	public Long insert(Store store)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + store);

		if (store == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		store.setCreateAt(currentTimeMillis);
		store.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(store);
		} catch (DaoException e) {
			log.error(" insert wrong : " + store);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Store> insertList(List<Store> storeList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (storeList == null ? "null" : storeList.size()));

		List<Store> resultList = null;

		if (CollectionUtils.isEmpty(storeList)) {
			return new ArrayList<Store>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Store store : storeList) {
			store.setCreateAt(currentTimeMillis);
			store.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Store>) dao.batchSave(storeList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + storeList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Store.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Store store)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (store == null ? "null" : store.getId()));

		boolean result = false;

		if (store == null) {
			return true;
		}

		store.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(store);
		} catch (DaoException e) {
			log.error(" update wrong : " + store);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + store);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Store> storeList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (storeList == null ? "null" : storeList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(storeList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Store store : storeList) {
			store.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(storeList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + storeList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + storeList.size());

		return result;
	}


	@Override
	public Store getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Store store = null;

		if (id == null) {
			return store;
		}

		try {
			store = (Store) dao.get(Store.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return store;
	}


	@Override
	public List<Store> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Store> store = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Store>();
		}

		try {
			store = (List<Store>) dao.getList(Store.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (store == null ? "null" : store.size()));

		return store;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getStoreIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkNum,start,limit  : " + trademarkNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getStoreIdsByTrademarkNum", new Object[] { trademarkNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkNum,start,limit)  : " + trademarkNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getStoreIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by trademarkId,start,limit  : " + trademarkId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getStoreIdsByTrademarkId", new Object[] { trademarkId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getStoreIdByStoreNum(String storeNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by storeNum  : " + storeNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getStoreIdByStoreNum", new Object[] {storeNum });
		} catch (DaoException e) {
			log.error(" get id wrong by storeNum  : " + storeNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countStoreIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkNum  : " + trademarkNum );
		}
		Integer count=null;



		try {

			count = dao.count("getStoreIdsByTrademarkNum", new Object[] { trademarkNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkNum)  : " + trademarkNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countStoreIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by trademarkId  : " + trademarkId );
		}
		Integer count=null;



		try {

			count = dao.count("getStoreIdsByTrademarkId", new Object[] { trademarkId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by trademarkId)  : " + trademarkId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getStoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getStoreIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	@Override
	public List<Long> getStoreIdsByMtOnline(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getStoreIdsByMtOnline",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countStoreIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getStoreIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getStoreIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

