package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.GroupFoodSort;
import com.ptteng.onway.platform.service.GroupFoodSortService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class GroupFoodSortServiceImpl extends BaseDaoServiceImpl implements GroupFoodSortService {



	private static final Log log = LogFactory.getLog(GroupFoodSortServiceImpl.class);




	@Override
	public Long insert(GroupFoodSort groupFoodSort)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + groupFoodSort);

		if (groupFoodSort == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		groupFoodSort.setCreateAt(currentTimeMillis);
		groupFoodSort.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(groupFoodSort);
		} catch (DaoException e) {
			log.error(" insert wrong : " + groupFoodSort);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<GroupFoodSort> insertList(List<GroupFoodSort> groupFoodSortList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (groupFoodSortList == null ? "null" : groupFoodSortList.size()));

		List<GroupFoodSort> resultList = null;

		if (CollectionUtils.isEmpty(groupFoodSortList)) {
			return new ArrayList<GroupFoodSort>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GroupFoodSort groupFoodSort : groupFoodSortList) {
			groupFoodSort.setCreateAt(currentTimeMillis);
			groupFoodSort.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<GroupFoodSort>) dao.batchSave(groupFoodSortList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + groupFoodSortList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(GroupFoodSort.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(GroupFoodSort groupFoodSort)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (groupFoodSort == null ? "null" : groupFoodSort.getId()));

		boolean result = false;

		if (groupFoodSort == null) {
			return true;
		}

		groupFoodSort.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(groupFoodSort);
		} catch (DaoException e) {
			log.error(" update wrong : " + groupFoodSort);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + groupFoodSort);
		}
		return result;
	}


	@Override
	public boolean updateList(List<GroupFoodSort> groupFoodSortList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (groupFoodSortList == null ? "null" : groupFoodSortList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(groupFoodSortList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (GroupFoodSort groupFoodSort : groupFoodSortList) {
			groupFoodSort.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(groupFoodSortList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + groupFoodSortList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + groupFoodSortList.size());

		return result;
	}


	@Override
	public GroupFoodSort getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		GroupFoodSort groupFoodSort = null;

		if (id == null) {
			return groupFoodSort;
		}

		try {
			groupFoodSort = (GroupFoodSort) dao.get(GroupFoodSort.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return groupFoodSort;
	}


	@Override
	public List<GroupFoodSort> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<GroupFoodSort> groupFoodSort = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<GroupFoodSort>();
		}

		try {
			groupFoodSort = (List<GroupFoodSort>) dao.getList(GroupFoodSort.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (groupFoodSort == null ? "null" : groupFoodSort.size()));

		return groupFoodSort;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getGroupFoodSortIdByStoreNumAndGroupNumAndFoodNum(String storeNum,String groupNum,String foodNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by storeNum,groupNum,foodNum  : " + storeNum+" , "+groupNum+" , "+foodNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getGroupFoodSortIdByStoreNumAndGroupNumAndFoodNum", new Object[] {storeNum,groupNum,foodNum });
		} catch (DaoException e) {
			log.error(" get id wrong by storeNum,groupNum,foodNum  : " + storeNum+" , "+groupNum+" , "+foodNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getGroupFoodSortIdsByStoreNumAndFoodNum(String storeNum,String foodNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeNum,foodNum,start,limit  : " + storeNum+" , "+foodNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getGroupFoodSortIdsByStoreNumAndFoodNum", new Object[] { storeNum,foodNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,foodNum,start,limit)  : " + storeNum+" , "+foodNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getGroupFoodSortIdsByStoreNumAndGroupNum(String storeNum,String groupNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeNum,groupNum,start,limit  : " + storeNum+" , "+groupNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getGroupFoodSortIdsByStoreNumAndGroupNum", new Object[] { storeNum,groupNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,groupNum,start,limit)  : " + storeNum+" , "+groupNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getGroupFoodSortIdsByStoreNum(String storeNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeNum,start,limit  : " + storeNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getGroupFoodSortIdsByStoreNum", new Object[] { storeNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,start,limit)  : " + storeNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countGroupFoodSortIdsByStoreNumAndFoodNum(String storeNum,String foodNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by storeNum,foodNum  : " + storeNum+" , "+foodNum );
		}
		Integer count=null;



		try {

			count = dao.count("getGroupFoodSortIdsByStoreNumAndFoodNum", new Object[] { storeNum,foodNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by storeNum,foodNum)  : " + storeNum+" , "+foodNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countGroupFoodSortIdsByStoreNumAndGroupNum(String storeNum,String groupNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by storeNum,groupNum  : " + storeNum+" , "+groupNum );
		}
		Integer count=null;



		try {

			count = dao.count("getGroupFoodSortIdsByStoreNumAndGroupNum", new Object[] { storeNum,groupNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by storeNum,groupNum)  : " + storeNum+" , "+groupNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countGroupFoodSortIdsByStoreNum(String storeNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by storeNum  : " + storeNum );
		}
		Integer count=null;



		try {

			count = dao.count("getGroupFoodSortIdsByStoreNum", new Object[] { storeNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by storeNum)  : " + storeNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getGroupFoodSortIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getGroupFoodSortIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countGroupFoodSortIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getGroupFoodSortIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getGroupFoodSortIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

