package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.FoodTypeRelation;
import com.ptteng.onway.platform.service.FoodTypeRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class FoodTypeRelationServiceImpl extends BaseDaoServiceImpl implements FoodTypeRelationService {

 

	private static final Log log = LogFactory.getLog(FoodTypeRelationServiceImpl.class);



		   
		@Override
		public Long insert(FoodTypeRelation foodTypeRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + foodTypeRelation);

		if (foodTypeRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		foodTypeRelation.setCreateAt(currentTimeMillis);
		foodTypeRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(foodTypeRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + foodTypeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<FoodTypeRelation> insertList(List<FoodTypeRelation> foodTypeRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (foodTypeRelationList == null ? "null" : foodTypeRelationList.size()));
      
		List<FoodTypeRelation> resultList = null;

		if (CollectionUtils.isEmpty(foodTypeRelationList)) {
			return new ArrayList<FoodTypeRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodTypeRelation foodTypeRelation : foodTypeRelationList) {
			foodTypeRelation.setCreateAt(currentTimeMillis);
			foodTypeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<FoodTypeRelation>) dao.batchSave(foodTypeRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + foodTypeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(FoodTypeRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(FoodTypeRelation foodTypeRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (foodTypeRelation == null ? "null" : foodTypeRelation.getId()));

		boolean result = false;

		if (foodTypeRelation == null) {
			return true;
		}

		foodTypeRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(foodTypeRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + foodTypeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + foodTypeRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<FoodTypeRelation> foodTypeRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (foodTypeRelationList == null ? "null" : foodTypeRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(foodTypeRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodTypeRelation foodTypeRelation : foodTypeRelationList) {
			foodTypeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(foodTypeRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + foodTypeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + foodTypeRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public FoodTypeRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		FoodTypeRelation foodTypeRelation = null;

		if (id == null) {
			return foodTypeRelation;
		}

		try {
			foodTypeRelation = (FoodTypeRelation) dao.get(FoodTypeRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return foodTypeRelation;		
		}	
		  
    	   
		@Override
		public List<FoodTypeRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<FoodTypeRelation> foodTypeRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<FoodTypeRelation>();
		}

		try {
			foodTypeRelation = (List<FoodTypeRelation>) dao.getList(FoodTypeRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (foodTypeRelation == null ? "null" : foodTypeRelation.size()));
    
		return foodTypeRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getFoodTypeRelationIdsByStoreId(Long storeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by storeId,start,limit  : " + storeId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getFoodTypeRelationIdsByStoreId", new Object[] { storeId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by storeId,start,limit)  : " + storeId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getFoodTypeRelationIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by trademarkId,start,limit  : " + trademarkId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getFoodTypeRelationIdsByTrademarkId", new Object[] { trademarkId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by trademarkId,start,limit)  : " + trademarkId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countFoodTypeRelationIdsByStoreId(Long storeId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by storeId  : " + storeId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getFoodTypeRelationIdsByStoreId", new Object[] { storeId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by storeId)  : " + storeId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countFoodTypeRelationIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by trademarkId  : " + trademarkId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getFoodTypeRelationIdsByTrademarkId", new Object[] { trademarkId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by trademarkId)  : " + trademarkId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getFoodTypeRelationIdByNameAndStoreId(String name,Long storeId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by name,storeId  : " + name+" , "+storeId );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getFoodTypeRelationIdByNameAndStoreId", new Object[] {name,storeId });
		} catch (DaoException e) {
			log.error(" get id wrong by name,storeId  : " + name+" , "+storeId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getFoodTypeRelationIdByName(String name)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by name  : " + name );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getFoodTypeRelationIdByName", new Object[] {name });
		} catch (DaoException e) {
			log.error(" get id wrong by name  : " + name );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getFoodTypeRelationIdByTypeNum(String typeNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by typeNum  : " + typeNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getFoodTypeRelationIdByTypeNum", new Object[] {typeNum });
		} catch (DaoException e) {
			log.error(" get id wrong by typeNum  : " + typeNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}





	@Override
	public List<Long> getFoodTypeRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getFoodTypeRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countFoodTypeRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFoodTypeRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFoodTypeRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

