package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.FoodSpecRelation;
import com.ptteng.onway.platform.service.FoodSpecRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class FoodSpecRelationServiceImpl extends BaseDaoServiceImpl implements FoodSpecRelationService {

 

	private static final Log log = LogFactory.getLog(FoodSpecRelationServiceImpl.class);



		   
		@Override
		public Long insert(FoodSpecRelation foodSpecRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + foodSpecRelation);

		if (foodSpecRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		foodSpecRelation.setCreateAt(currentTimeMillis);
		foodSpecRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(foodSpecRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + foodSpecRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<FoodSpecRelation> insertList(List<FoodSpecRelation> foodSpecRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (foodSpecRelationList == null ? "null" : foodSpecRelationList.size()));
      
		List<FoodSpecRelation> resultList = null;

		if (CollectionUtils.isEmpty(foodSpecRelationList)) {
			return new ArrayList<FoodSpecRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodSpecRelation foodSpecRelation : foodSpecRelationList) {
			foodSpecRelation.setCreateAt(currentTimeMillis);
			foodSpecRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<FoodSpecRelation>) dao.batchSave(foodSpecRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + foodSpecRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(FoodSpecRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(FoodSpecRelation foodSpecRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (foodSpecRelation == null ? "null" : foodSpecRelation.getId()));

		boolean result = false;

		if (foodSpecRelation == null) {
			return true;
		}

		foodSpecRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(foodSpecRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + foodSpecRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + foodSpecRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<FoodSpecRelation> foodSpecRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (foodSpecRelationList == null ? "null" : foodSpecRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(foodSpecRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodSpecRelation foodSpecRelation : foodSpecRelationList) {
			foodSpecRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(foodSpecRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + foodSpecRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + foodSpecRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public FoodSpecRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		FoodSpecRelation foodSpecRelation = null;

		if (id == null) {
			return foodSpecRelation;
		}

		try {
			foodSpecRelation = (FoodSpecRelation) dao.get(FoodSpecRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return foodSpecRelation;		
		}	
		  
    	   
		@Override
		public List<FoodSpecRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<FoodSpecRelation> foodSpecRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<FoodSpecRelation>();
		}

		try {
			foodSpecRelation = (List<FoodSpecRelation>) dao.getList(FoodSpecRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (foodSpecRelation == null ? "null" : foodSpecRelation.size()));
    
		return foodSpecRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getFoodSpecRelationIdsByTargetId(Long targetId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by targetId,start,limit  : " + targetId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getFoodSpecRelationIdsByTargetId", new Object[] { targetId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by targetId,start,limit)  : " + targetId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countFoodSpecRelationIdsByTargetId(Long targetId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by targetId  : " + targetId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getFoodSpecRelationIdsByTargetId", new Object[] { targetId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by targetId)  : " + targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getFoodSpecRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getFoodSpecRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countFoodSpecRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFoodSpecRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFoodSpecRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

