package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.FoodSolid;
import com.ptteng.onway.platform.service.FoodSolidService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class FoodSolidServiceImpl extends BaseDaoServiceImpl implements FoodSolidService {

 

	private static final Log log = LogFactory.getLog(FoodSolidServiceImpl.class);



		   
		@Override
		public Long insert(FoodSolid foodSolid)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + foodSolid);

		if (foodSolid == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		foodSolid.setCreateAt(currentTimeMillis);
		foodSolid.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(foodSolid);
		} catch (DaoException e) {
			log.error(" insert wrong : " + foodSolid);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<FoodSolid> insertList(List<FoodSolid> foodSolidList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (foodSolidList == null ? "null" : foodSolidList.size()));
      
		List<FoodSolid> resultList = null;

		if (CollectionUtils.isEmpty(foodSolidList)) {
			return new ArrayList<FoodSolid>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodSolid foodSolid : foodSolidList) {
			foodSolid.setCreateAt(currentTimeMillis);
			foodSolid.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<FoodSolid>) dao.batchSave(foodSolidList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + foodSolidList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(FoodSolid.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(FoodSolid foodSolid)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (foodSolid == null ? "null" : foodSolid.getId()));

		boolean result = false;

		if (foodSolid == null) {
			return true;
		}

		foodSolid.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(foodSolid);
		} catch (DaoException e) {
			log.error(" update wrong : " + foodSolid);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + foodSolid);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<FoodSolid> foodSolidList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (foodSolidList == null ? "null" : foodSolidList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(foodSolidList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodSolid foodSolid : foodSolidList) {
			foodSolid.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(foodSolidList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + foodSolidList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + foodSolidList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public FoodSolid getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		FoodSolid foodSolid = null;

		if (id == null) {
			return foodSolid;
		}

		try {
			foodSolid = (FoodSolid) dao.get(FoodSolid.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return foodSolid;		
		}	
		  
    	   
		@Override
		public List<FoodSolid> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<FoodSolid> foodSolid = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<FoodSolid>();
		}

		try {
			foodSolid = (List<FoodSolid>) dao.getList(FoodSolid.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (foodSolid == null ? "null" : foodSolid.size()));
    
		return foodSolid;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getFoodSolidIdByStoreNumAndGroupNumAndFoodNumAndStatus(String storeNum,String groupNum,String foodNum,Integer status)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by storeNum,groupNum,foodNum,status  : " + storeNum+" , "+groupNum+" , "+foodNum+" , "+status );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getFoodSolidIdByStoreNumAndGroupNumAndFoodNumAndStatus", new Object[] {storeNum,groupNum,foodNum,status });
   } catch (DaoException e) {
			log.error(" get id wrong by storeNum,groupNum,foodNum,status  : " + storeNum+" , "+groupNum+" , "+foodNum+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFoodSolidIdsByStoreNum(String storeNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeNum,start,limit  : " + storeNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodSolidIdsByStoreNum", new Object[] { storeNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,start,limit)  : " + storeNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFoodSolidIdsByStoreNumAndStatus(String storeNum,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by storeNum,start,status,limit  : " + storeNum+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodSolidIdsByStoreNumAndStatus", new Object[] { storeNum,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,status,start,limit)  : " + storeNum+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getFoodSolidIdsByStoreNumAndGroupNumAndStatus(String storeNum,String groupNum,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by storeNum,groupNum,status,start,limit  : " + storeNum+" , "+groupNum+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getFoodSolidIdsByStoreNumAndGroupNumAndStatus", new Object[] { storeNum,groupNum,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by storeNum,groupNum,status,start,limit)  : " + storeNum+" , "+groupNum+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countFoodSolidIdsByStoreNumAndGroupNumAndStatus(String storeNum,String groupNum,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by storeNum,groupNum,status  : " + storeNum+" , "+groupNum+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getFoodSolidIdsByStoreNumAndGroupNumAndStatus", new Object[] { storeNum,groupNum,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by storeNum,groupNum,status)  : " + storeNum+" , "+groupNum+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getFoodSolidIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getFoodSolidIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countFoodSolidIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFoodSolidIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFoodSolidIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

