package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.Food;
import com.ptteng.onway.platform.service.FoodService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class FoodServiceImpl extends BaseDaoServiceImpl implements FoodService {



	private static final Log log = LogFactory.getLog(FoodServiceImpl.class);




	@Override
	public Long insert(Food food)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + food);

		if (food == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		food.setCreateAt(currentTimeMillis);
		food.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(food);
		} catch (DaoException e) {
			log.error(" insert wrong : " + food);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Food> insertList(List<Food> foodList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (foodList == null ? "null" : foodList.size()));

		List<Food> resultList = null;

		if (CollectionUtils.isEmpty(foodList)) {
			return new ArrayList<Food>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Food food : foodList) {
			food.setCreateAt(currentTimeMillis);
			food.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Food>) dao.batchSave(foodList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + foodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Food.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Food food)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (food == null ? "null" : food.getId()));

		boolean result = false;

		if (food == null) {
			return true;
		}

		food.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(food);
		} catch (DaoException e) {
			log.error(" update wrong : " + food);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + food);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Food> foodList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (foodList == null ? "null" : foodList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(foodList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Food food : foodList) {
			food.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(foodList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + foodList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + foodList.size());

		return result;
	}


	@Override
	public Food getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Food food = null;

		if (id == null) {
			return food;
		}

		try {
			food = (Food) dao.get(Food.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return food;
	}


	@Override
	public List<Food> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Food> food = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Food>();
		}

		try {
			food = (List<Food>) dao.getList(Food.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (food == null ? "null" : food.size()));

		return food;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getFoodIdByFoodNum(String foodNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by foodNum  : " + foodNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getFoodIdByFoodNum", new Object[] {foodNum });
		} catch (DaoException e) {
			log.error(" get id wrong by foodNum  : " + foodNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFoodIdsByfoodType(Integer foodType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by foodType,start,limit  : " + foodType+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodIdsByfoodType", new Object[] { foodType},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by foodType,start,limit)  : " + foodType+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countFoodIdsByfoodType(Integer foodType)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by foodType  : " + foodType );
		}
		Integer count=null;



		try {

			count = dao.count("getFoodIdsByfoodType", new Object[] { foodType});


		} catch (DaoException e) {
			log.error(" count ids  wrong by foodType)  : " + foodType );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getFoodIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countFoodIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFoodIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFoodIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

