package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.FoodOrderRelation;
import com.ptteng.onway.platform.service.FoodOrderRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class FoodOrderRelationServiceImpl extends BaseDaoServiceImpl implements FoodOrderRelationService {



	private static final Log log = LogFactory.getLog(FoodOrderRelationServiceImpl.class);




	@Override
	public Long insert(FoodOrderRelation foodOrderRelation)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + foodOrderRelation);

		if (foodOrderRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		foodOrderRelation.setCreateAt(currentTimeMillis);
		foodOrderRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(foodOrderRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + foodOrderRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<FoodOrderRelation> insertList(List<FoodOrderRelation> foodOrderRelationList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (foodOrderRelationList == null ? "null" : foodOrderRelationList.size()));

		List<FoodOrderRelation> resultList = null;

		if (CollectionUtils.isEmpty(foodOrderRelationList)) {
			return new ArrayList<FoodOrderRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodOrderRelation foodOrderRelation : foodOrderRelationList) {
			foodOrderRelation.setCreateAt(currentTimeMillis);
			foodOrderRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<FoodOrderRelation>) dao.batchSave(foodOrderRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + foodOrderRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(FoodOrderRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(FoodOrderRelation foodOrderRelation)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (foodOrderRelation == null ? "null" : foodOrderRelation.getId()));

		boolean result = false;

		if (foodOrderRelation == null) {
			return true;
		}

		foodOrderRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(foodOrderRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + foodOrderRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + foodOrderRelation);
		}
		return result;
	}


	@Override
	public boolean updateList(List<FoodOrderRelation> foodOrderRelationList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (foodOrderRelationList == null ? "null" : foodOrderRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(foodOrderRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (FoodOrderRelation foodOrderRelation : foodOrderRelationList) {
			foodOrderRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(foodOrderRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + foodOrderRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + foodOrderRelationList.size());

		return result;
	}


	@Override
	public FoodOrderRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		FoodOrderRelation foodOrderRelation = null;

		if (id == null) {
			return foodOrderRelation;
		}

		try {
			foodOrderRelation = (FoodOrderRelation) dao.get(FoodOrderRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return foodOrderRelation;
	}


	@Override
	public List<FoodOrderRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<FoodOrderRelation> foodOrderRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<FoodOrderRelation>();
		}

		try {
			foodOrderRelation = (List<FoodOrderRelation>) dao.getList(FoodOrderRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (foodOrderRelation == null ? "null" : foodOrderRelation.size()));

		return foodOrderRelation;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFoodOrderRelationIdsByOrderId(Long orderId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by orderId,start,limit  : " + orderId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodOrderRelationIdsByOrderId", new Object[] { orderId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by orderId,start,limit)  : " + orderId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getFoodOrderRelationIdsByOrderNum(String orderNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by orderNum,start,limit  : " + orderNum+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodOrderRelationIdsByOrderNum", new Object[] { orderNum},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by orderNum,start,limit)  : " + orderNum+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countFoodOrderRelationIdsByOrderId(Long orderId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by orderId  : " + orderId );
		}
		Integer count=null;



		try {

			count = dao.count("getFoodOrderRelationIdsByOrderId", new Object[] { orderId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by orderId)  : " + orderId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countFoodOrderRelationIdsByOrderNum(String orderNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by orderNum  : " + orderNum );
		}
		Integer count=null;



		try {

			count = dao.count("getFoodOrderRelationIdsByOrderNum", new Object[] { orderNum});


		} catch (DaoException e) {
			log.error(" count ids  wrong by orderNum)  : " + orderNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getFoodOrderRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getFoodOrderRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countFoodOrderRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getFoodOrderRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getFoodOrderRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

