package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.EvaluateOrderRelation;
import com.ptteng.onway.platform.service.EvaluateOrderRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class EvaluateOrderRelationServiceImpl extends BaseDaoServiceImpl implements EvaluateOrderRelationService {



	private static final Log log = LogFactory.getLog(EvaluateOrderRelationServiceImpl.class);




	@Override
	public Long insert(EvaluateOrderRelation evaluateOrderRelation)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + evaluateOrderRelation);

		if (evaluateOrderRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		evaluateOrderRelation.setCreateAt(currentTimeMillis);
		evaluateOrderRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(evaluateOrderRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + evaluateOrderRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<EvaluateOrderRelation> insertList(List<EvaluateOrderRelation> evaluateOrderRelationList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (evaluateOrderRelationList == null ? "null" : evaluateOrderRelationList.size()));

		List<EvaluateOrderRelation> resultList = null;

		if (CollectionUtils.isEmpty(evaluateOrderRelationList)) {
			return new ArrayList<EvaluateOrderRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (EvaluateOrderRelation evaluateOrderRelation : evaluateOrderRelationList) {
			evaluateOrderRelation.setCreateAt(currentTimeMillis);
			evaluateOrderRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<EvaluateOrderRelation>) dao.batchSave(evaluateOrderRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + evaluateOrderRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(EvaluateOrderRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(EvaluateOrderRelation evaluateOrderRelation)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (evaluateOrderRelation == null ? "null" : evaluateOrderRelation.getId()));

		boolean result = false;

		if (evaluateOrderRelation == null) {
			return true;
		}

		evaluateOrderRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(evaluateOrderRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + evaluateOrderRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + evaluateOrderRelation);
		}
		return result;
	}


	@Override
	public boolean updateList(List<EvaluateOrderRelation> evaluateOrderRelationList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (evaluateOrderRelationList == null ? "null" : evaluateOrderRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(evaluateOrderRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (EvaluateOrderRelation evaluateOrderRelation : evaluateOrderRelationList) {
			evaluateOrderRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(evaluateOrderRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + evaluateOrderRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + evaluateOrderRelationList.size());

		return result;
	}


	@Override
	public EvaluateOrderRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		EvaluateOrderRelation evaluateOrderRelation = null;

		if (id == null) {
			return evaluateOrderRelation;
		}

		try {
			evaluateOrderRelation = (EvaluateOrderRelation) dao.get(EvaluateOrderRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return evaluateOrderRelation;
	}


	@Override
	public List<EvaluateOrderRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<EvaluateOrderRelation> evaluateOrderRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<EvaluateOrderRelation>();
		}

		try {
			evaluateOrderRelation = (List<EvaluateOrderRelation>) dao.getList(EvaluateOrderRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (evaluateOrderRelation == null ? "null" : evaluateOrderRelation.size()));

		return evaluateOrderRelation;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getEvaluateOrderRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getEvaluateOrderRelationIdsByUid", new Object[] { uid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getEvaluateOrderRelationIdByPlatformOrderNum(String platformOrderNum)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by platformOrderNum  : " + platformOrderNum );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getEvaluateOrderRelationIdByPlatformOrderNum", new Object[] {platformOrderNum });
		} catch (DaoException e) {
			log.error(" get id wrong by platformOrderNum  : " + platformOrderNum );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getEvaluateOrderRelationIdByOrderId(Long orderId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by orderId  : " + orderId );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getEvaluateOrderRelationIdByOrderId", new Object[] {orderId });
		} catch (DaoException e) {
			log.error(" get id wrong by orderId  : " + orderId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countEvaluateOrderRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uid  : " + uid );
		}
		Integer count=null;



		try {

			count = dao.count("getEvaluateOrderRelationIdsByUid", new Object[] { uid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getEvaluateOrderRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getEvaluateOrderRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	@Override
	public List<Long> getEvaluateOrderRelationIdsByStoreIdPlatform(Long storeId,String platform,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by storeId,platform,start,limit  ================== "+ storeId + " , "+ platform + " , "  + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getEvaluateOrderRelationIdsByStoreIdPlatform",new Object[] {storeId,platform},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countEvaluateOrderRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getEvaluateOrderRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getEvaluateOrderRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

