package com.ptteng.onway.platform.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.BusinessHours;
import com.ptteng.onway.platform.service.BusinessHoursService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class BusinessHoursServiceImpl extends BaseDaoServiceImpl implements BusinessHoursService {



	private static final Log log = LogFactory.getLog(BusinessHoursServiceImpl.class);




	@Override
	public Long insert(BusinessHours businessHours)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + businessHours);

		if (businessHours == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		businessHours.setCreateAt(currentTimeMillis);
		businessHours.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(businessHours);
		} catch (DaoException e) {
			log.error(" insert wrong : " + businessHours);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<BusinessHours> insertList(List<BusinessHours> businessHoursList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (businessHoursList == null ? "null" : businessHoursList.size()));

		List<BusinessHours> resultList = null;

		if (CollectionUtils.isEmpty(businessHoursList)) {
			return new ArrayList<BusinessHours>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BusinessHours businessHours : businessHoursList) {
			businessHours.setCreateAt(currentTimeMillis);
			businessHours.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<BusinessHours>) dao.batchSave(businessHoursList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + businessHoursList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(BusinessHours.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(BusinessHours businessHours)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (businessHours == null ? "null" : businessHours.getId()));

		boolean result = false;

		if (businessHours == null) {
			return true;
		}

		businessHours.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(businessHours);
		} catch (DaoException e) {
			log.error(" update wrong : " + businessHours);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + businessHours);
		}
		return result;
	}


	@Override
	public boolean updateList(List<BusinessHours> businessHoursList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (businessHoursList == null ? "null" : businessHoursList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(businessHoursList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BusinessHours businessHours : businessHoursList) {
			businessHours.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(businessHoursList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + businessHoursList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + businessHoursList.size());

		return result;
	}


	@Override
	public BusinessHours getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		BusinessHours businessHours = null;

		if (id == null) {
			return businessHours;
		}

		try {
			businessHours = (BusinessHours) dao.get(BusinessHours.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return businessHours;
	}


	@Override
	public List<BusinessHours> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<BusinessHours> businessHours = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<BusinessHours>();
		}

		try {
			businessHours = (List<BusinessHours>) dao.getList(BusinessHours.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (businessHours == null ? "null" : businessHours.size()));

		return businessHours;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getBusinessHoursIdsByTargetId(Long targetId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by targetId,start,limit  : " + targetId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getBusinessHoursIdsByTargetId", new Object[] { targetId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by targetId,start,limit)  : " + targetId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getBusinessHoursIdsByTargetIdAndStatus(Long targetId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by targetId,status,start,limit  : " + targetId+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getBusinessHoursIdsByTargetIdAndStatus", new Object[] { targetId,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by targetId,status,start,limit)  : " + targetId+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getBusinessHoursIdByTargetIdAndMealTypeAndStatus(Long targetId,Integer mealType,Integer status)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by targetId,mealType,status  : " + targetId+" , "+mealType+" , "+status );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getBusinessHoursIdByTargetIdAndMealTypeAndStatus", new Object[] {targetId,mealType,status });
		} catch (DaoException e) {
			log.error(" get id wrong by targetId,mealType,status  : " + targetId+" , "+mealType+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countBusinessHoursIdsByTargetId(Long targetId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by targetId  : " + targetId );
		}
		Integer count=null;



		try {

			count = dao.count("getBusinessHoursIdsByTargetId", new Object[] { targetId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by targetId)  : " + targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getBusinessHoursIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getBusinessHoursIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countBusinessHoursIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBusinessHoursIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBusinessHoursIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

