package com.ptteng.sca.onway.platform.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.WaimaiStoreConsumerService;

import java.util.List;

/**
 * Author wanglei
 * Created on 17-11-15
 */
public class WaimaiStoreSCAClient implements WaimaiStoreConsumerService {


    private WaimaiStoreConsumerService waimaiStoreConsumerService;


    public WaimaiStoreConsumerService getWaimaiStoreConsumerService() {
        return waimaiStoreConsumerService;
    }


    public void setWaimaiStoreConsumerService(WaimaiStoreConsumerService waimaiStoreConsumerService) {
        this.waimaiStoreConsumerService =waimaiStoreConsumerService;
    }

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.updateStore(mchId, storeId, waimaiStoreDTO);
    }

    @Override
    public void updateStoreByPlatform(Long mchId, Long storeId, List<String> platformTypes, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.updateStoreByPlatform(mchId, storeId, platformTypes, waimaiStoreDTO);
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.onlineStore(mchId, storeId);
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.offlineStore(mchId, storeId);
    }

    @Override
    public void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.onlineStoreByPlatform(mchId, storeId, platform);
    }

    @Override
    public void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.offlineStoreByPlatform(mchId, storeId, platform);
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        return waimaiStoreConsumerService.getStoreComment(mchId, storeId, startTime, endTime, pageSize);
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        waimaiStoreConsumerService.replyStoreComment(mchId, storeId, commentId, replyContent);
    }
}
