package com.ptteng.sca.onway.platform.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiOrderMappingDTO;
import com.ptteng.onway.platform.model.WaimaiStoreMappingDTO;
import com.ptteng.onway.platform.service.WaimaiService;

/**
 * Author wanglei
 * Created on 17-11-15
 */
public class WaimaiSCAClient implements WaimaiService {

    private WaimaiService waimaiService;


    public WaimaiService getWaimaiService() {
        return waimaiService;
    }


    public void setWaimaiService(WaimaiService waimaiService) {
        this.waimaiService = waimaiService;
    }


    @Override
    public void saveWaiMaiLog(String cmd, String method, Boolean isSuccess, String request, String response) throws ServiceException, ServiceDaoException {
        waimaiService.saveWaiMaiLog(cmd, method, isSuccess, request, response);
    }

    @Override
    public WaimaiStoreMappingDTO findStoreMappingByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException {
        return waimaiService.findStoreMappingByMappingIdPlatformType(mappingId, platformType);
    }

    @Override
    public WaimaiStoreMappingDTO findStoreMappingByStoreIdPlatformType(Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        return waimaiService.findStoreMappingByStoreIdPlatformType(storeId, platformType);
    }

    @Override
    public WaimaiOrderMappingDTO findOrderMappingByTargetIdPlatformType(String targetId, String platformType) throws ServiceException, ServiceDaoException {
        return waimaiService.findOrderMappingByTargetIdPlatformType(targetId, platformType);
    }

    @Override
    public void saveOrderMapping(Long mchId, Long storeId, Long orderId, String targetId, String viewId, String platformType) throws ServiceException, ServiceDaoException {

    }
}
