package com.ptteng.sca.onway.platform.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.service.WaimaiOrderHandleService;

/**
 * Author wanglei
 * Created on 17-11-15
 */
public class WaimaiOrderSCAClient implements WaimaiOrderHandleService {



    private WaimaiOrderHandleService waimaiOrderHandleService;


    public WaimaiOrderHandleService getWaimaiOrderHandleService() {
        return waimaiOrderHandleService;
    }


    public void setWaimaiOrderHandleService(WaimaiOrderHandleService waimaiOrderHandleService) {
        this.waimaiOrderHandleService =waimaiOrderHandleService;
    }



    @Override
    public void confirm(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        waimaiOrderHandleService.confirm(mchId, storeId, orderId);
    }

    @Override
    public void cancel(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        waimaiOrderHandleService.cancel(mchId, storeId, orderId, reasonId, reason);
    }

    @Override
    public void complete(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        waimaiOrderHandleService.complete(mchId, storeId, orderId);
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        waimaiOrderHandleService.agreeRefund(mchId, storeId, orderId);
    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
        waimaiOrderHandleService.disagreeRefund(mchId, storeId, orderId, reason);
    }
}
