package com.ptteng.sca.onway.platform.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.WaimaiDishConsumerService;

import java.util.List;

/**
 * Author wanglei
 * Created on 17-11-15
 */
public class WaimaiDishSCAClient implements WaimaiDishConsumerService {

    private  WaimaiDishConsumerService waimaiDishConsumerService;


    public WaimaiDishConsumerService getWaimaiDishConsumerService() {
        return waimaiDishConsumerService;
    }


    public void setWaimaiDishConsumerService(WaimaiDishConsumerService waimaiDishConsumerService) {
        this.waimaiDishConsumerService =waimaiDishConsumerService;
    }



    @Override
    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
    }

    @Override
    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.updateDishGroup(mchId, storeId, dishGroupId, dishGroup);
    }

    @Override
    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.onlineDish(mchId, storeId, dishNormId, dishNormWmDTO);
    }

    @Override
    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.offlineDish(mchId, storeId, dishNormId);
    }

    @Override
    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.updateDish(mchId, storeId, dishNormId, dishNormWmDTO);
    }

    @Override
    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.batchUpdateDish(mchId, storeId, dishNormWmDTOs);
    }

    @Override
    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {
        waimaiDishConsumerService.setThreshold(mchId, storeId, dishNormId, stock);
    }
}
