/**
 *
 */
package com.ptteng.sca.onway.platform.client;

import java.util.List;
import java.util.Map;

import com.ptteng.onway.platform.model.UserOrder;
import com.ptteng.onway.platform.service.UserOrderService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class UserOrderSCAClient implements UserOrderService {

	private UserOrderService userOrderService;

	public UserOrderService getUserOrderService() {
		return userOrderService;
	}


	public void setUserOrderService(UserOrderService userOrderService) {
		this.userOrderService =userOrderService;
	}



	@Override
	public Long insert(UserOrder userOrder)throws ServiceException, ServiceDaoException{

		return userOrderService.insert(userOrder);


	}


	@Override
	public List<UserOrder> insertList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{

		return userOrderService.insertList(userOrderList);


	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{

		return userOrderService.delete(id);


	}


	@Override
	public boolean update(UserOrder userOrder)throws ServiceException, ServiceDaoException{

		return userOrderService.update(userOrder);


	}


	@Override
	public boolean updateList(List<UserOrder> userOrderList)throws ServiceException, ServiceDaoException{

		return userOrderService.updateList(userOrderList);


	}


	@Override
	public UserOrder getObjectById(Long id)throws ServiceException, ServiceDaoException{

		return userOrderService.getObjectById(id);


	}


	@Override
	public List<UserOrder> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{

		return userOrderService.getObjectsByIds(ids);


	}








	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByPlatform(String platform,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdsByPlatform(platform,start,limit);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserOrderIdByOrderNum(Long orderNum)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdByOrderNum(orderNum);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getUserOrderIdByPlatformOrderNum(String platformOrderNum)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdByPlatformOrderNum(platformOrderNum);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByBuyAt(Long startBuyAt,Long endBuyAt,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdsByBuyAt(startBuyAt,endBuyAt,start,limit);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdsByTrademarkId(trademarkId,start,limit);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus,Integer orderStatus,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdsByAcceptStatusAndOrderStatus(acceptStatus,orderStatus,start,limit);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserOrderIdsByStoreId(Long storeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return userOrderService.getUserOrderIdsByStoreId(storeId,start,limit);


	}






	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByPlatform(String platform)throws ServiceException, ServiceDaoException{

		return userOrderService.countUserOrderIdsByPlatform(platform);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByBuyAt(Long startBuyAt,Long endBuyAt)throws ServiceException, ServiceDaoException{

		return userOrderService.countUserOrderIdsByBuyAt(startBuyAt,endBuyAt);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{

		return userOrderService.countUserOrderIdsByTrademarkId(trademarkId);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByAcceptStatusAndOrderStatus(Integer acceptStatus,Integer orderStatus)throws ServiceException, ServiceDaoException{

		return userOrderService.countUserOrderIdsByAcceptStatusAndOrderStatus(acceptStatus,orderStatus);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countUserOrderIdsByStoreId(Long storeId)throws ServiceException, ServiceDaoException{

		return userOrderService.countUserOrderIdsByStoreId(storeId);


	}



	@Override
	public List<Long> getUserOrderIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.getUserOrderIds(start, limit);
	}

	@Override
	public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.countUserOrderIds();
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return userOrderService.fakeDelete(clz, id);
	}



	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		userOrderService.deleteList(clz, ids);

	}

	@Override
	public Object getObjectByDynamicCondition(Class clz,
											  Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.userOrderService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}



}

