/**
 *
 */
package com.ptteng.sca.onway.platform.client;

import java.util.List;
import java.util.Map;

import com.ptteng.onway.platform.model.Trademark;
import com.ptteng.onway.platform.service.TrademarkService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class TrademarkSCAClient implements TrademarkService {

	private TrademarkService trademarkService;

	public TrademarkService getTrademarkService() {
		return trademarkService;
	}


	public void setTrademarkService(TrademarkService trademarkService) {
		this.trademarkService =trademarkService;
	}



	@Override
	public Long insert(Trademark trademark)throws ServiceException, ServiceDaoException{

		return trademarkService.insert(trademark);


	}


	@Override
	public List<Trademark> insertList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException{

		return trademarkService.insertList(trademarkList);


	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{

		return trademarkService.delete(id);


	}


	@Override
	public boolean update(Trademark trademark)throws ServiceException, ServiceDaoException{

		return trademarkService.update(trademark);


	}


	@Override
	public boolean updateList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException{

		return trademarkService.updateList(trademarkList);


	}


	@Override
	public Trademark getObjectById(Long id)throws ServiceException, ServiceDaoException{

		return trademarkService.getObjectById(id);


	}


	@Override
	public List<Trademark> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{

		return trademarkService.getObjectsByIds(ids);


	}








	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getTrademarkIdByName(String name)throws ServiceException, ServiceDaoException{

		return trademarkService.getTrademarkIdByName(name);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getTrademarkIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return trademarkService.getTrademarkIdsByTrademarkNum(trademarkNum,start,limit);


	}






	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countTrademarkIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		return trademarkService.countTrademarkIdsByTrademarkNum(trademarkNum);


	}



	@Override
	public List<Long> getTrademarkIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return trademarkService.getTrademarkIds(start, limit);
	}

	@Override
	public Integer countTrademarkIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return trademarkService.countTrademarkIds();
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return trademarkService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return trademarkService.fakeDelete(clz, id);
	}



	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		trademarkService.deleteList(clz, ids);

	}

	@Override
	public Object getObjectByDynamicCondition(Class clz,
											  Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.trademarkService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}



}

