/**
 *
 */
package com.ptteng.sca.onway.platform.client;

import java.util.List;
import java.util.Map;

import com.ptteng.onway.platform.model.Store;
import com.ptteng.onway.platform.service.StoreService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class StoreSCAClient implements StoreService {

	private StoreService storeService;

	public StoreService getStoreService() {
		return storeService;
	}


	public void setStoreService(StoreService storeService) {
		this.storeService =storeService;
	}



	@Override
	public Long insert(Store store)throws ServiceException, ServiceDaoException{

		return storeService.insert(store);


	}


	@Override
	public List<Store> insertList(List<Store> storeList)throws ServiceException, ServiceDaoException{

		return storeService.insertList(storeList);


	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{

		return storeService.delete(id);


	}


	@Override
	public boolean update(Store store)throws ServiceException, ServiceDaoException{

		return storeService.update(store);


	}


	@Override
	public boolean updateList(List<Store> storeList)throws ServiceException, ServiceDaoException{

		return storeService.updateList(storeList);


	}


	@Override
	public Store getObjectById(Long id)throws ServiceException, ServiceDaoException{

		return storeService.getObjectById(id);


	}


	@Override
	public List<Store> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{

		return storeService.getObjectsByIds(ids);


	}








	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getStoreIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return storeService.getStoreIdsByTrademarkNum(trademarkNum,start,limit);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getStoreIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return storeService.getStoreIdsByTrademarkId(trademarkId,start,limit);


	}






	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countStoreIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException{

		return storeService.countStoreIdsByTrademarkNum(trademarkNum);


	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countStoreIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException{

		return storeService.countStoreIdsByTrademarkId(trademarkId);


	}



	@Override
	public List<Long> getStoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return storeService.getStoreIds(start, limit);
	}

	@Override
	public Integer countStoreIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return storeService.countStoreIds();
	}


	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return storeService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return storeService.fakeDelete(clz, id);
	}



	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		storeService.deleteList(clz, ids);

	}

	@Override
	public Object getObjectByDynamicCondition(Class clz,
											  Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.storeService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}



}

