package com.ptteng.onway.platform.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 * Author wanglei
 * Created on 17-11-14
 */
@Remotable
public interface WaimaiStoreConsumerService {

    /**
     *  更新门店信息
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param waimaiStoreDTO 门店信息
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException;

    /**
     *  根据平台更新门店信息
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param platformTypes 平台类型
     * @param waimaiStoreDTO 门店信息
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void updateStoreByPlatform(Long mchId, Long storeId, List<String> platformTypes, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException;

    /**
     * 门店上线（所有外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    /**
     * 门店下线（所有外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException;

    /**
     * 门店上线（单个外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param platform 平台代码
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException;

    /**
     * 门店下线（单个外卖平台）
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param platform 平台代码
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException;

    /**
     * 获取门店评论
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param startTime 开始时间（单位秒）
     * @param endTime 结束时间（单位秒）
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException;

    /**
     * 回复门店评论
     * @param mchId 品牌id
     * @param storeId 门店id
     * @param commentId 评论id
     * @param replyContent 回复内容
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException;
}
