package com.ptteng.onway.platform.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import org.osoa.sca.annotations.Remotable;

/**
 * Author wanglei
 * Created on 17-11-15
 */
@Remotable
public interface WaimaiOrderHandleService {

    void confirm(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException;

    void cancel(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException;

    void complete(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException;

    void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException;

    void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException;
}
