package com.ptteng.onway.platform.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 * Author wanglei
 * Created on 17-11-14
 */
@Remotable
public interface WaimaiDishConsumerService {

    //创建菜品分类
    void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException;
    //修改菜品分类
    void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException;
    //菜品上架
    void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException;
    //菜品下架
    void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException;
    //修改菜品
    void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException;
    //批量更新菜品
    void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException;
    //设置菜品库存
    void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException;
}
