package com.ptteng.onway.platform.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.Trademark;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface TrademarkService extends BaseDaoService {







	public Long insert(Trademark trademark)throws ServiceException, ServiceDaoException;



	public List<Trademark> insertList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(Trademark trademark)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<Trademark> trademarkList)throws ServiceException, ServiceDaoException;



	public Trademark getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<Trademark> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countTrademarkIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getTrademarkIdByName(String name)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getTrademarkIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getTrademarkIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countTrademarkIds() throws ServiceException, ServiceDaoException;


}

