package com.ptteng.onway.platform.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.*;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

/**
 * Created by ${zhangfan} on 2017/11/7.
 */
@Remotable
public interface TemplateTestService {


        //订单统计
        public  List<OrderStatistics> getOrderStatisticsByTimeAndStoreId(Long start_at, Long  end_at,Long storeId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkId(Long start_at, Long  end_at,Long trademarkId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsByTimeAndStoreIdAndOrderStatus(Long start_at, Long  end_at,Long storeId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long  end_at,Long trademarkId) throws ServiceException, ServiceDaoException;

        public  List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkId(Long start_at, Long  end_at,Long TrademarkId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreId(Long start_at, Long  end_at,Long storeId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long  end_at,Long TrademarkId) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(Long start_at, Long  end_at,Long storeId) throws ServiceException, ServiceDaoException;

        public  List<OrderStatistics> getTrademarkOrderStatisticsByTimeAndOrderStatus(Long start_at, Long  end_at,Long TrademarkId,Integer orderType) throws ServiceException, ServiceDaoException;
        public  List<OrderStatistics> getTrademarkOrderStatisticsByPlatform(Long start_at, Long  end_at,Long TrademarkId,Integer orderType) throws ServiceException, ServiceDaoException;

        //菜品统计
        public List<FoodStatistics> getTrademarkFoodStatisticsByTime (Long startAt,Long endAt,Long trademarkId) throws ServiceException, ServiceDaoException;
        public List<FoodStatistics> getStoreFoodStatisticsByTime (Long startAt,Long endAt,Long storeId) throws ServiceException, ServiceDaoException;


        //菜品详细统计
        public List<FoodStatistics> getStoreFoodStatisticsDetailBuyTime (Long startAt,Long endAt,Long storeId,Integer sort,Integer foodType) throws ServiceException, ServiceDaoException;


        //用户统计
        public List<UserStatistics> getUserStatisticsByTimeAndStoreId (Long startAt,Long endAt,Long storeId,Long
                trademarkId) throws ServiceException,ServiceDaoException;
        public List<UserStatistics> getUserStatisticsByTimeAndTrademarkId (Long startAt,Long endAt,Long
                trademarkId) throws ServiceException,ServiceDaoException;

        //评价统计
        public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndStoreId (Long startAt, Long endAt, Long trademarkId, Long
                storeId) throws ServiceException,ServiceDaoException;
        public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndTrademarkId (Long startAt, Long endAt, Long trademarkId) throws ServiceException,ServiceDaoException;
}

