package com.ptteng.onway.platform.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.Store;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface StoreService extends BaseDaoService {







	public Long insert(Store store)throws ServiceException, ServiceDaoException;



	public List<Store> insertList(List<Store> storeList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(Store store)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<Store> storeList)throws ServiceException, ServiceDaoException;



	public Store getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<Store> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStoreIdsByTrademarkNum(String trademarkNum)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStoreIdsByTrademarkId(Long trademarkId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStoreIdsByTrademarkNum(String trademarkNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStoreIdsByTrademarkId(Long trademarkId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStoreIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStoreIds() throws ServiceException, ServiceDaoException;


}

