package com.ptteng.onway.platform.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.onway.platform.model.FoodOrderRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface FoodOrderRelationService extends BaseDaoService {







	public Long insert(FoodOrderRelation foodOrderRelation)throws ServiceException, ServiceDaoException;



	public List<FoodOrderRelation> insertList(List<FoodOrderRelation> foodOrderRelationList)throws ServiceException, ServiceDaoException;



	public boolean delete(Long id)throws ServiceException, ServiceDaoException;



	public boolean update(FoodOrderRelation foodOrderRelation)throws ServiceException, ServiceDaoException;



	public boolean updateList(List<FoodOrderRelation> foodOrderRelationList)throws ServiceException, ServiceDaoException;



	public FoodOrderRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;



	public List<FoodOrderRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countFoodOrderRelationIdsByOrderId(Long orderId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countFoodOrderRelationIdsByOrderNum(String orderNum)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getFoodOrderRelationIdsByOrderId(Long orderId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getFoodOrderRelationIdsByOrderNum(String orderNum,Integer start,Integer limit)throws ServiceException, ServiceDaoException;




	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getFoodOrderRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countFoodOrderRelationIds() throws ServiceException, ServiceDaoException;


}

