package com.ptteng.onway.platform.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import java.math.BigDecimal;
import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "user_order")
public class UserOrder implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8124230467697582080L;	
	
		
   	 
    private  Long id;
	
  	 
    private  Long trademarkId;
    private  String trademarkName;

  	 
    private  Long storeId;
	private  Long uid;
  	 
    private  String storeName;
	
  	 
    private  String platform;
	
  	 
    private  String userName;
	
  	 
    private  Integer buyCount;
	
  	 
    private  Integer sex;
	
  	 
    private  String mobile;
	
  	 
    private  String deliveryAddress;
	
  	 
    private  String expectTime;
	
  	 
    private  Long buyAt;
	
  	 
    private  Long acceptAt;
	
  	 
    private  Long endAt;
	
  	 
    private  Integer acceptStatus=1;
	/*
	* 接单状态1待接单 2已接单 3已拒绝 默认待接单
	* */
  	public static final int ACCEPT_STATUS_WAIT = 1;
  	public static final int ACCEPT_STATUS_FINISH = 2;
  	public static final int ACCEPT_STATUS_CANCEL = 3;

    private  Integer orderStatus=1;
	/*
	* 订单状态 0取消 1未完成 2配送中 3配送完成 4退款中 5已退 默认未完成
	* */
	public static final int ORDER_STATUS_CANCEL = 0;
	public static final int ORDER_STATUS_UNDONE = 1;
	public static final int ORDER_STATUS_PROCESSING = 2;
	public static final int ORDER_STATUS_FINISH = 3;
	public static final int ORDER_STATUS_REFUNDING = 4;
	public static final int ORDER_STATUS_REFUNDED= 5;

    private  String cancelReason;
	
  	 
    private  BigDecimal orderPrice;
	
  	 
    private  BigDecimal boxFee;
	
  	 
    private  BigDecimal deliveryFee;
	
  	 
    private  BigDecimal payFee;
	
  	 
    private  BigDecimal promotionFee;
	
  	 
    private  BigDecimal brokerage;
	
  	 
    private  BigDecimal platformSubsidy;
	
  	 
    private  Integer payWay;
	/*
    * 支付途径 1支付宝 2微信 3银行卡
    * */
	public static final int PAY_WAY_ALIPAY = 1;
	public static final int PAY_WAY_WEIXIN = 2;
	public static final int PAY_WAY_CARD = 3;

  	 
    private  String orderNum;
	
  	 
    private  String platformOrderNum;
	
  	 
    private  String courierMobile;
	
  	 
    private  String deliveryMethod;
	
  	 
    private  String orderRemarks;
	
  	 
    private  Integer invoice=0;
	/*
	* 是否需要发票 0不需要 1需要 默认不需要
	* */
	public static final int INVOICE_NOT_NEED = 0;
	public static final int INVOICE_NEED = 1;
  	 
    private  String invoiceTitle;
	
  	 
    private  String taxNum;
	
  	 
    private  Integer invoiceMark=0;
	/*
	* 发票开具状态 0未开 1已开 默认未开
	* */
	public static final int INVOICE_MARK_FALSE = 0;
	public static final int INVOICE_MARK_TRUE = 1;
  	 
    private  Integer printStatus=0;
	/*
	* 订单打印状态 0未打 1已打 默认未打
	* */
	public static final int PRINT_STATUS_FALSE = 0;
	public static final int PRINT_STATUS_TRUE = 1;
  	 
    private  Long createBy;
	
  	 
    private  Long updateBy;
	
  	 
    private  Long updateAt;
	
  	 
    private  Long createAt;
    private  Integer sort;

  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "trademark_id")
	public Long getTrademarkId() {
		return trademarkId;
	}
	
	
	public void setTrademarkId(Long trademarkId) {
		this.trademarkId = trademarkId;
	}
	@Column(name = "uid")
	public Long getUid() {
		return uid;
	}


	public void setUid(Long uid) {
		this.uid = uid;
	}

	@Transient
	public String getTrademarkName() {
		return trademarkName;
	}

	public void setTrademarkName(String trademarkName) {
		this.trademarkName = trademarkName;
	}
		 	@Column(name = "store_id")
	public Long getStoreId() {
		return storeId;
	}
	
	
	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}
		 	@Column(name = "store_name")
	public String getStoreName() {
		return storeName;
	}
	
	
	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}
		 	@Column(name = "platform")
	public String getPlatform() {
		return platform;
	}
	
	
	public void setPlatform(String platform) {
		this.platform = platform;
	}
		 	@Column(name = "user_name")
	public String getUserName() {
		return userName;
	}
	
	
	public void setUserName(String userName) {
		this.userName = userName;
	}
		 	@Column(name = "buy_count")
	public Integer getBuyCount() {
		return buyCount;
	}
	
	
	public void setBuyCount(Integer buyCount) {
		this.buyCount = buyCount;
	}
		 	@Column(name = "sex")
	public Integer getSex() {
		return sex;
	}
	
	
	public void setSex(Integer sex) {
		this.sex = sex;
	}
		 	@Column(name = "mobile")
	public String getMobile() {
		return mobile;
	}
	
	
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
		 	@Column(name = "delivery_address")
	public String getDeliveryAddress() {
		return deliveryAddress;
	}
	
	
	public void setDeliveryAddress(String deliveryAddress) {
		this.deliveryAddress = deliveryAddress;
	}
		 	@Column(name = "expect_time")
	public String getExpectTime() {
		return expectTime;
	}
	
	
	public void setExpectTime(String expectTime) {
		this.expectTime = expectTime;
	}
		 	@Column(name = "buy_at")
	public Long getBuyAt() {
		return buyAt;
	}
	
	
	public void setBuyAt(Long buyAt) {
		this.buyAt = buyAt;
	}
		 	@Column(name = "accept_at")
	public Long getAcceptAt() {
		return acceptAt;
	}
	
	
	public void setAcceptAt(Long acceptAt) {
		this.acceptAt = acceptAt;
	}
		 	@Column(name = "end_at")
	public Long getEndAt() {
		return endAt;
	}
	
	
	public void setEndAt(Long endAt) {
		this.endAt = endAt;
	}
		 	@Column(name = "accept_status")
	public Integer getAcceptStatus() {
		return acceptStatus;
	}
	
	
	public void setAcceptStatus(Integer acceptStatus) {
		this.acceptStatus = acceptStatus;
	}
		 	@Column(name = "order_status")
	public Integer getOrderStatus() {
		return orderStatus;
	}
	
	
	public void setOrderStatus(Integer orderStatus) {
		this.orderStatus = orderStatus;
	}
		 	@Column(name = "cancel_reason")
	public String getCancelReason() {
		return cancelReason;
	}
	
	
	public void setCancelReason(String cancelReason) {
		this.cancelReason = cancelReason;
	}
		 	@Column(name = "order_price")
	public BigDecimal getOrderPrice() {
		return orderPrice;
	}
	
	
	public void setOrderPrice(BigDecimal orderPrice) {
		this.orderPrice = orderPrice;
	}
		 	@Column(name = "box_fee")
	public BigDecimal getBoxFee() {
		return boxFee;
	}
	
	
	public void setBoxFee(BigDecimal boxFee) {
		this.boxFee = boxFee;
	}
		 	@Column(name = "delivery_fee")
	public BigDecimal getDeliveryFee() {
		return deliveryFee;
	}
	
	
	public void setDeliveryFee(BigDecimal deliveryFee) {
		this.deliveryFee = deliveryFee;
	}
		 	@Column(name = "pay_fee")
	public BigDecimal getPayFee() {
		return payFee;
	}
	
	
	public void setPayFee(BigDecimal payFee) {
		this.payFee = payFee;
	}
		 	@Column(name = "promotion_fee")
	public BigDecimal getPromotionFee() {
		return promotionFee;
	}
	
	
	public void setPromotionFee(BigDecimal promotionFee) {
		this.promotionFee = promotionFee;
	}
		 	@Column(name = "brokerage")
	public BigDecimal getBrokerage() {
		return brokerage;
	}
	
	
	public void setBrokerage(BigDecimal brokerage) {
		this.brokerage = brokerage;
	}
		 	@Column(name = "platform_subsidy")
	public BigDecimal getPlatformSubsidy() {
		return platformSubsidy;
	}
	
	
	public void setPlatformSubsidy(BigDecimal platformSubsidy) {
		this.platformSubsidy = platformSubsidy;
	}
		 	@Column(name = "pay_way")
	public Integer getPayWay() {
		return payWay;
	}
	
	
	public void setPayWay(Integer payWay) {
		this.payWay = payWay;
	}
		 	@Column(name = "order_num")
	public String getOrderNum() {
		return orderNum;
	}
	
	
	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}
		 	@Column(name = "platform_order_num")
	public String getPlatformOrderNum() {
		return platformOrderNum;
	}
	
	
	public void setPlatformOrderNum(String platformOrderNum) {
		this.platformOrderNum = platformOrderNum;
	}
		 	@Column(name = "courier_mobile")
	public String getCourierMobile() {
		return courierMobile;
	}
	
	
	public void setCourierMobile(String courierMobile) {
		this.courierMobile = courierMobile;
	}
		 	@Column(name = "delivery_method")
	public String getDeliveryMethod() {
		return deliveryMethod;
	}
	
	
	public void setDeliveryMethod(String deliveryMethod) {
		this.deliveryMethod = deliveryMethod;
	}
		 	@Column(name = "order_remarks")
	public String getOrderRemarks() {
		return orderRemarks;
	}
	
	
	public void setOrderRemarks(String orderRemarks) {
		this.orderRemarks = orderRemarks;
	}
		 	@Column(name = "invoice")
	public Integer getInvoice() {
		return invoice;
	}
	
	
	public void setInvoice(Integer invoice) {
		this.invoice = invoice;
	}
		 	@Column(name = "invoice_title")
	public String getInvoiceTitle() {
		return invoiceTitle;
	}
	
	
	public void setInvoiceTitle(String invoiceTitle) {
		this.invoiceTitle = invoiceTitle;
	}
		 	@Column(name = "tax_num")
	public String getTaxNum() {
		return taxNum;
	}
	
	
	public void setTaxNum(String taxNum) {
		this.taxNum = taxNum;
	}
		 	@Column(name = "invoice_mark")
	public Integer getInvoiceMark() {
		return invoiceMark;
	}
	
	
	public void setInvoiceMark(Integer invoiceMark) {
		this.invoiceMark = invoiceMark;
	}
		 	@Column(name = "print_status")
	public Integer getPrintStatus() {
		return printStatus;
	}
	
	
	public void setPrintStatus(Integer printStatus) {
		this.printStatus = printStatus;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}


	public void setSort(Integer sort) {
		this.sort = sort;
	}
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

