package com.ptteng.onway.platform.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.omg.PortableInterceptor.INACTIVE;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by Master on 2017/11/9.
 */
public class FoodStatistics implements Serializable {
    private static final long serialVersionUID = 6569864371641835545L;

    /*
    * 排序约定
    * 1-美团外卖销量
    * 2-饿了么
    * 3-百度
    * 4-总销量
    * 5-销售占比
    * 6-销售额
    * 7-销售额占比
    *
    *
    * */
    public static final int ORDER_MEITUAN =1;
    public static final int ORDER_MEITUAN_DESC =-1;
    public static final int ORDER_ELE =2;
    public static final int ORDER_ELE_DESC =-2;
    public static final int ORDER_BAIDU =3;
    public static final int ORDER_BAIDU_DESC =-3;
    public static final int ORDER_QUANTITY =4;
    public static final int ORDER_QUANTITY_DESC =-4;
    public static final int ORDER_SALES_PROPORTION =5;
    public static final int ORDER_SALES_PROPORTION_DESC =-5;
    public static final int ORDER_SALES_AMOUNT =6;
    public static final int ORDER_SALES_AMOUNT_DESC =-6;
    public static final int ORDER_AMOUNT_PROPORTION =7;
    public static final int ORDER_AMOUNT_PROPORTION_DESC =-7;

    private Long id;
    private String name;
    private Integer meituanCount=0;
    private Integer baiduCount=0;
    private Integer eleCount=0;
    private BigDecimal salesProportion= BigDecimal.ZERO;
    private BigDecimal salesAmount= BigDecimal.ZERO;
    private BigDecimal amountProportion= BigDecimal.ZERO;


    private Integer quantity=0;
    private String foodType;

    private BigDecimal price = BigDecimal.ZERO;

    private BigDecimal discountAmount = BigDecimal.ZERO;

    private  Integer cancelCount = 0;

    private BigDecimal cancelAmount = BigDecimal.ZERO;



    public void setId (Long id) {this.id = id;}
    public Long getId() {return id;}

    public void setFoodType (String foodType) {this.foodType = foodType;}
    public String getFoodType() {return foodType;}

    public void setName (String name) { this.name = name;}
    public String getName () { return name;}

    public void setMeituanCount (Integer meituanCount) { this.meituanCount = meituanCount;}
    public Integer getMeituanCount () { return meituanCount;}

    public void setBaiduCount (Integer baiduCount) { this.baiduCount = meituanCount;}
    public Integer getBaiduCount () { return baiduCount;}

    public void setEleCount (Integer eleCount) { this.eleCount = eleCount;}
    public Integer getEleCount () { return eleCount;}

    public void setSalesProportion (BigDecimal salesProportion) { this.salesProportion = salesProportion;}
    public BigDecimal getSalesProportion  () { return salesProportion;}

    public void setSalesAmount (BigDecimal salesAmount) { this.salesAmount = salesProportion;}
    public BigDecimal getSalesAmount  () { return salesAmount;}

    public void setAmountProportion (BigDecimal amountProportion) { this.amountProportion = amountProportion;}
    public BigDecimal getAmountProportion  () { return amountProportion;}




    public void setQuantity (Integer quantity) { this.quantity = quantity;}
    public Integer getQuantity () { return quantity;}

    public void setPrice (BigDecimal price) { this.price = price;}
    public BigDecimal getPrice () { return price;}

    public void setDiscountAmount (BigDecimal discountAmount) { this.discountAmount = discountAmount ;}
    public BigDecimal getDiscountAmount () { return discountAmount;}

    public void setCancelCount (Integer cancelCount) { this.cancelCount = cancelCount;}
    public Integer getCancelCount () { return cancelCount;}

    public void setCancelAmount (BigDecimal cancelAmount) { this.cancelAmount = cancelAmount;}
    public BigDecimal getCancelAmount () { return cancelAmount;}

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }
}
